/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.metadata;

import java.util.Optional;
import java.util.function.Function;
import javax.wsdl.Part;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.OperationType;

abstract class NodeMetadataResolver {
    final PortModel port;
    final BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.XML);
    final MetadataType nullType = this.typeBuilder.nullType().build();
    final TypeLoader loader;
    final Function<OperationModel, Optional<Part>> bodyPartRetriever;

    NodeMetadataResolver(PortModel port, TypeLoader loader, Function<OperationModel, Optional<Part>> bodyPartRetriever) {
        this.port = port;
        this.loader = loader;
        this.bodyPartRetriever = bodyPartRetriever;
    }

    abstract MetadataType getMetadata(String var1) throws MetadataResolvingException;

    MetadataType buildPartMetadataType(Part part) throws MetadataResolvingException {
        if (part.getElementName() != null) {
            String partName = part.getElementName().toString();
            return this.loader.load(partName).orElseThrow(() -> new MetadataResolvingException(String.format("Could not load part element name [%s]", partName), FailureCode.UNKNOWN));
        }
        throw new MetadataResolvingException("Trying to resolve metadata for a nameless part, probably the provided WSDL is invalid", FailureCode.INVALID_CONFIGURATION);
    }

    Part getBodyPart(String operation) throws MetadataResolvingException {
        return this.bodyPartRetriever.apply(this.port.getOperation(operation)).orElseThrow(() -> {
            String errorMsg = "No body type found for operation [" + operation + "]";
            return new MetadataResolvingException(errorMsg, FailureCode.INVALID_METADATA_KEY);
        });
    }

    boolean isOneWay(String operationName) {
        return OperationType.ONE_WAY.equals((Object)this.port.getOperation(operationName).getType());
    }
}

