/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import org.mule.weave.v2.interpreted.DefaultModuleNodeLoader;
import org.mule.weave.v2.interpreted.InterpretedMappingExecutableWeave;
import org.mule.weave.v2.interpreted.InterpretedModuleExecutableWeave;
import org.mule.weave.v2.interpreted.InterpreterMappingCompilerPhase;
import org.mule.weave.v2.interpreted.InterpreterModuleCompilerPhase;
import org.mule.weave.v2.interpreted.debugger.server.DefaultWeaveDebuggingSession;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol;
import org.mule.weave.v2.interpreted.debugger.server.tcp.TcpServerDebuggerProtocol$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.module.ModuleNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.AstNodeResultAware;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.ExecutableWeaveHelper$;
import org.mule.weave.v2.runtime.utils.AnsiColor$;
import org.mule.weave.v2.runtime.utils.CustomRunner;
import org.mule.weave.v2.runtime.utils.RunnerConfiguration;
import org.mule.weave.v2.sdk.ClassLoaderWeaveResourceResolver$;
import org.mule.weave.v2.sdk.ParsingContextFactory$;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory$;
import org.mule.weave.v2.ts.WeaveType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Either;
import scala.util.Right;

public final class DefaultCustomRunner$
implements CustomRunner {
    public static DefaultCustomRunner$ MODULE$;

    static {
        new DefaultCustomRunner$();
    }

    @Override
    public String runnerName() {
        return "default";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Either<RunnerConfiguration, String> parseArgs(String[] args) {
        Right right;
        PrintStream printStream = System.out;
        Seq inputs = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq parameters = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean debug = false;
        WeaveResource resource = null;
        NameIdentifier nameIdentifier = null;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty()) {
            right = package$.MODULE$.Right().apply((Object)"Data Weave File was not specified.");
            return right;
        }
        File file = new File((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).last());
        if (!file.exists()) {
            WeaveResource value;
            nameIdentifier = new NameIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).last(), NameIdentifier$.MODULE$.apply$default$2());
            Option<WeaveResource> mayBeUrl = ClassLoaderWeaveResourceResolver$.MODULE$.resolve(nameIdentifier);
            Option<WeaveResource> option = mayBeUrl;
            if (!(option instanceof Some)) {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                return package$.MODULE$.Right().apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load weave file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).last()})));
            }
            Some some = (Some)option;
            resource = value = (WeaveResource)some.value();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            resource = WeaveResourceFactory$.MODULE$.fromFile(file);
            String filePath = file.getPath();
            String basePath = new File(".").getAbsolutePath();
            String path = filePath;
            if (filePath.startsWith(basePath)) {
                path = filePath.substring(basePath.length());
            }
            nameIdentifier = NameIdentifier$.MODULE$.fromPath(path);
        }
        String[] configArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).slice(0, args.length - 1);
        int index = 0;
        while (true) {
            BoxedUnit boxedUnit;
            if (index >= configArgs.length) {
                void var5_3;
                right = package$.MODULE$.Left().apply((Object)new RunnerConfiguration(resource, nameIdentifier, (OutputStream)var5_3, (Seq<Tuple2<String, File>>)inputs, (Seq<String>)parameters, debug));
                return right;
            }
            String string = configArgs[index];
            if ("-input".equals(string)) {
                if (index + 2 >= configArgs.length) return package$.MODULE$.Right().apply((Object)AnsiColor$.MODULE$.red("Invalid amount of arguments on input."));
                File input = new File(configArgs[index + 2]);
                String inputName = configArgs[index + 1];
                if (!input.exists()) {
                    return package$.MODULE$.Right().apply((Object)AnsiColor$.MODULE$.red(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid input file ", " ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputName, input.getAbsolutePath()}))));
                }
                inputs = (Seq)inputs.$colon$plus((Object)new Tuple2((Object)inputName, (Object)input), Seq$.MODULE$.canBuildFrom());
                index += 2;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl = "-param".equals(string) ? true : "-p".equals(string);
                if (bl) {
                    if (index + 1 >= configArgs.length) return package$.MODULE$.Right().apply((Object)AnsiColor$.MODULE$.red("Invalid amount of arguments on param."));
                    String paramValue = configArgs[index + 1];
                    parameters = (Seq)parameters.$colon$plus((Object)paramValue, Seq$.MODULE$.canBuildFrom());
                    index += 2;
                    boxedUnit = BoxedUnit.UNIT;
                } else if ("-output".equals(string)) {
                    if (index + 1 >= configArgs.length) return package$.MODULE$.Right().apply((Object)AnsiColor$.MODULE$.red("Invalid amount of arguments on output."));
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(configArgs[index + 1]));
                    ++index;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (!"-debug".equals(string)) {
                        return package$.MODULE$.Right().apply((Object)AnsiColor$.MODULE$.red(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid argument ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}))));
                    }
                    debug = true;
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ParsingContext createParsingContextFor(RunnerConfiguration configuration, NameIdentifier nameIdentifier) {
        void var3_3;
        ParsingContext parsingContext = ParsingContextFactory$.MODULE$.createParsingContext(nameIdentifier);
        configuration.inputs().foreach((Function1 & Serializable & scala.Serializable)input -> parsingContext.addImplicitInput((String)input._1(), (Option<WeaveType>)None$.MODULE$));
        return var3_3;
    }

    public void run(RunnerConfiguration config) {
        WeaveResource resource = config.resource();
        NameIdentifier nameIdentifier = config.nameIdentifier();
        ParsingContext parsingContext = this.createParsingContextFor(config, nameIdentifier);
        DocumentParser documentParser = new DocumentParser(0);
        PhaseResult<ParsingResult<AstNode>> parse = documentParser.parse(resource, parsingContext);
        PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult = documentParser.typeCheck(documentParser.scopeCheck(documentParser.canonical(parse, parsingContext), parsingContext), parsingContext);
        Seq<Tuple2<WeaveLocation, Message>> warningMessages = typeCheckResult.warningMessages();
        if (typeCheckResult.hasResult()) {
            int n;
            TypeCheckingResult<? extends AstNode> result;
            Object t;
            if (warningMessages.nonEmpty()) {
                warningMessages.foreach((Function1 & Serializable & scala.Serializable)message -> {
                    Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.yellow(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Warning] ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Message)message._2()).message()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" {", ":", "}:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().line()), BoxesRunTime.boxToInteger((int)((WeaveLocation)message._1()).startPosition().column()), ((WeaveLocation)message._1()).locationString()}))));
                    return BoxedUnit.UNIT;
                });
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Warnings where found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)warningMessages.size())})));
            }
            if ((t = (result = typeCheckResult.getResult()).astNode()) instanceof DocumentNode) {
                n = this.runMapping(config, parsingContext, typeCheckResult);
            } else if (t instanceof ModuleNode) {
                n = this.runModule(config, parsingContext, typeCheckResult);
            } else {
                throw new MatchError(t);
            }
            int statusCode = n;
            System.exit(statusCode);
        } else {
            Predef$.MODULE$.println((Object)typeCheckResult.messages().errorMessageString());
            Predef$.MODULE$.println((Object)typeCheckResult.messages().warningMessageString());
            if (typeCheckResult.hasErrors() || typeCheckResult.isEmpty()) {
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Errors where found."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)typeCheckResult.errorMessages().size())}))));
                System.exit(1);
                return;
            }
        }
    }

    @Override
    public void usage() {
        Predef$.MODULE$.println((Object)"[-input <name> <value>]* [-param | -p <paramValue>]* [-debug]? [-output <path>]? <weave file path>");
    }

    public int runModule(RunnerConfiguration config, ParsingContext parsingContext, PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult) {
        IntRef responseCode;
        block1: {
            ExecutableWeave<ModuleNode> engine;
            Map values;
            EvaluationContext ctx;
            block0: {
                ctx = EvaluationContext$.MODULE$.apply();
                values = ((TraversableOnce)((TraversableLike)config.parameters().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)valueIndex -> new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)valueIndex._2$mcI$sp())).toString(), (Object)StringValue$.MODULE$.apply((String)valueIndex._1())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
                PhaseResult<? extends CompilationResult<ModuleNode>> result = new InterpreterModuleCompilerPhase(new DefaultModuleNodeLoader()).call((AstNodeResultAware<ModuleNode>)value, parsingContext);
                engine = result.getResult().executable();
                responseCode = IntRef.create((int)0);
                if (!config.debug()) break block0;
                CountDownLatch latch = new CountDownLatch(1);
                TcpServerDebuggerProtocol protocol = TcpServerDebuggerProtocol$.MODULE$.apply(TcpServerDebuggerProtocol$.MODULE$.apply$default$1());
                DefaultWeaveDebuggingSession debuggingSession = ((InterpretedModuleExecutableWeave)engine).debug(protocol);
                debuggingSession.addSessionListener(() -> new Thread(ctx, values, engine, responseCode, latch, protocol){
                    private final EvaluationContext ctx$1;
                    private final Map values$1;
                    private final ExecutableWeave engine$1;
                    private final IntRef responseCode$1;
                    private final CountDownLatch latch$1;
                    private final TcpServerDebuggerProtocol protocol$1;

                    public void run() {
                        Map x$2 = this.values$1;
                        Map<String, Reader> x$3 = this.engine$1.execute$default$1();
                        Value<?> value = this.engine$1.execute(x$3, x$2, this.ctx$1);
                        if (value.valueType(this.ctx$1).isInstanceOf(NumberType$.MODULE$, this.ctx$1)) {
                            this.responseCode$1.elem = ((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, this.ctx$1).evaluate(this.ctx$1)).toInt();
                        }
                        this.protocol$1.disconnect();
                        this.latch$1.countDown();
                    }
                    {
                        this.ctx$1 = ctx$1;
                        this.values$1 = values$1;
                        this.engine$1 = engine$1;
                        this.responseCode$1 = responseCode$1;
                        this.latch$1 = latch$1;
                        this.protocol$1 = protocol$1;
                    }
                }.start());
                Predef$.MODULE$.println((Object)"Waiting for debugger client to connect.");
                latch.await();
                break block1;
            }
            Map x$4 = values;
            Map<String, Reader> x$5 = engine.execute$default$1();
            Value<?> value = engine.execute(x$5, x$4, ctx);
            if (!value.valueType(ctx).isInstanceOf(NumberType$.MODULE$, ctx)) break block1;
            responseCode.elem = ((ScalaNumericAnyConversions)NumberType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInt();
        }
        return responseCode.elem;
    }

    public int runMapping(RunnerConfiguration config, ParsingContext parsingContext, PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult) {
        BoxedUnit boxedUnit;
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply();
        TypeCheckingResult<? extends AstNode> value = typeCheckResult.getResult();
        PhaseResult<CompilationResult<DocumentNode>> result = new InterpreterMappingCompilerPhase(new DefaultModuleNodeLoader()).call((AstNodeResultAware<DocumentNode>)value, parsingContext);
        ExecutableWeave<DocumentNode> engine = result.getResult().executable();
        if (config.debug()) {
            CountDownLatch latch = new CountDownLatch(1);
            TcpServerDebuggerProtocol protocol = TcpServerDebuggerProtocol$.MODULE$.apply(TcpServerDebuggerProtocol$.MODULE$.apply$default$1());
            DefaultWeaveDebuggingSession debuggingSession = ((InterpretedMappingExecutableWeave)engine).debug(protocol);
            debuggingSession.addSessionListener(() -> new Thread(config, ctx, engine, latch, protocol){
                private final RunnerConfiguration config$1;
                private final EvaluationContext ctx$2;
                private final ExecutableWeave engine$2;
                private final CountDownLatch latch$2;
                private final TcpServerDebuggerProtocol protocol$2;

                public void run() {
                    this.engine$2.write(ExecutableWeaveHelper$.MODULE$.buildWriter(this.engine$2, this.config$1.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(this.engine$2, (Map<String, Object>)this.config$1.inputs().toMap(Predef$.MODULE$.$conforms()), this.ctx$2), this.engine$2.write$default$3(), this.ctx$2);
                    this.protocol$2.disconnect();
                    this.latch$2.countDown();
                }
                {
                    this.config$1 = config$1;
                    this.ctx$2 = ctx$2;
                    this.engine$2 = engine$2;
                    this.latch$2 = latch$2;
                    this.protocol$2 = protocol$2;
                }
            }.start());
            Predef$.MODULE$.println((Object)"Waiting for debugger client to connect.");
            latch.await();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = engine.write(ExecutableWeaveHelper$.MODULE$.buildWriter(engine, config.output()), ExecutableWeaveHelper$.MODULE$.buildReaders(engine, (Map<String, Object>)config.inputs().toMap(Predef$.MODULE$.$conforms()), ctx), engine.write$default$3(), ctx);
        }
        return 0;
    }

    private DefaultCustomRunner$() {
        MODULE$ = this;
    }
}

