type MultipartPart = {
  headers?: {
    "Content-Disposition"?: {
      name: String,
      filename?: String
    },
    "Content-Type"?: String
  },
  content: Any
}

type Multipart = {
  preamble?: String,
  parts: {
    _?: MultipartPart
  }
}

fun field(opts: {|
  name: String,
  value: Any,
  mime?: String,
  fileName?: String
|}) = field(opts.name, opts.value, opts.mime default '', opts.fileName default '')

fun field(name: String, content: Any, mime: String = "", fileName: String = ""): MultipartPart =
  {
    headers: {
      ("Content-Type": mime) if mime != '',
      "Content-Disposition": {
        "name": name,
        ("filename": fileName) if fileName != ''
      }
    },
    content: content
  }

fun file(opts: {|
  name: String,
  path: String,
  mime?: String,
  fileName?: String
|}) = file(opts.name, opts.path, opts.mime default 'application/octet-stream', opts.fileName default 'filename')

fun file(fieldName: String, path: String, mime: String = 'application/octet-stream', sentFileName: String = 'filename') =
  field(fieldName, readUrl('classpath://$(path)', 'application/octet-stream') as Binary, mime, sentFileName)

fun form(parts: Array<MultipartPart>): Multipart =
  {
    parts: parts reduce ((val, carry = {}) ->
      carry ++
      { (val.headers['Content-Disposition'].name): val }
    )
  }

var boundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"

fun generateBoundary(len: Number = 70): String =
  using(maxChars = sizeOf(boundaryChars))
    (1 to len) map boundaryChars[floor(random() * maxChars)] joinBy ''
