/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.config.internal.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.dsl.model.NoSuchComponentModelException;
import org.mule.runtime.core.internal.value.MuleValueProviderServiceUtility;
import org.mule.runtime.extension.api.values.ComponentValueProvider;
import org.mule.runtime.extension.api.values.ConfigurationParameterValueProvider;

public class LazyValueProviderService
implements ValueProviderService,
Initialisable {
    public static final String NON_LAZY_VALUE_PROVIDER_SERVICE = "_muleNonLazyValueProviderService";
    private final Supplier<ValueProviderService> valueProviderServiceSupplier;
    private Supplier<ConfigurationComponentLocator> componentLocatorSupplier;
    private LazyComponentInitializerAdapter lazyComponentInitializer;
    @Inject
    @Named(value="_muleNonLazyValueProviderService")
    private ValueProviderService providerService;
    private ConfigurationComponentLocator componentLocator;

    LazyValueProviderService(LazyComponentInitializerAdapter lazyComponentInitializer, Supplier<ValueProviderService> valueProviderServiceSupplier, Supplier<ConfigurationComponentLocator> componentLocatorSupplier) {
        this.lazyComponentInitializer = lazyComponentInitializer;
        this.valueProviderServiceSupplier = valueProviderServiceSupplier;
        this.componentLocatorSupplier = componentLocatorSupplier;
    }

    @Override
    public ValueResult getValues(Location location, String providerName) {
        return this.initializeComponent(location).orElseGet(() -> this.providerService.getValues(location, providerName));
    }

    private Optional<ValueResult> initializeComponent(Location location) {
        Location locationWithOutConnection = this.locationWithOutConnection(location);
        try {
            this.lazyComponentInitializer.initializeComponent(locationWithOutConnection, false);
        }
        catch (Exception e) {
            Throwable rootException = ExceptionHelper.getRootException(e);
            if (rootException instanceof NoSuchComponentModelException) {
                return Optional.of(ValueResult.resultFrom(ResolvingFailure.Builder.newFailure(e).withFailureCode("INVALID_LOCATION").withMessage(String.format("Unable to resolve values. No component was found in the given location [%s]", location)).build()));
            }
            return Optional.of(ValueResult.resultFrom(ResolvingFailure.Builder.newFailure(e).withMessage("Unknown error occurred trying to resolve values. " + e.getMessage()).withFailureCode("UNKNOWN").build()));
        }
        return Optional.empty();
    }

    private Location locationWithOutConnection(Location location) {
        return MuleValueProviderServiceUtility.isConnection(location) ? MuleValueProviderServiceUtility.deleteLastPartFromLocation(location) : location;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.providerService = this.valueProviderServiceSupplier.get();
        this.componentLocator = this.componentLocatorSupplier.get();
    }

    public Optional<ValueProviderModel> getModel(Location location, String providerName) {
        boolean isConnection = MuleValueProviderServiceUtility.isConnection(location);
        if (isConnection) {
            location = MuleValueProviderServiceUtility.deleteLastPartFromLocation(location);
        }
        return this.getModel(location, isConnection, providerName);
    }

    private Optional<ValueProviderModel> getModel(Location location, boolean isConnection, String providerName) {
        Reference model = new Reference();
        this.componentLocator.find(location).ifPresent(provider -> {
            try {
                if (provider instanceof ComponentValueProvider) {
                    model.set(((ComponentValueProvider)((Object)provider)).getModels(providerName).get(0));
                } else if (provider instanceof ConfigurationParameterValueProvider) {
                    if (isConnection) {
                        model.set(((ConfigurationParameterValueProvider)((Object)provider)).getConnectionModels(providerName).get(0));
                    } else {
                        model.set(((ConfigurationParameterValueProvider)((Object)provider)).getConfigModels(providerName).get(0));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return Optional.ofNullable(model.get());
    }
}

