/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.Binding;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionModule;
import org.mule.runtime.api.metadata.TypedValue;

public class DefaultBindingContextBuilder
implements BindingContext.Builder {
    private Map<String, Supplier<TypedValue>> bindings;
    private List<ExpressionModule> modules;

    public DefaultBindingContextBuilder() {
        this.bindings = new HashMap<String, Supplier<TypedValue>>();
        this.modules = new ArrayList<ExpressionModule>();
    }

    public DefaultBindingContextBuilder(BindingContext bindingContext) {
        this.bindings = bindingContext.identifiers().stream().collect(Collectors.toMap(id -> id, id -> () -> bindingContext.lookup((String)id).get()));
        this.modules = new ArrayList<ExpressionModule>(bindingContext.modules());
    }

    @Override
    public BindingContext.Builder addBinding(String identifier, TypedValue value) {
        this.bindings.put(identifier, () -> value);
        return this;
    }

    @Override
    public BindingContext.Builder addBinding(String identifier, Supplier<TypedValue> lazyValue) {
        this.bindings.put(identifier, lazyValue);
        return this;
    }

    @Override
    public BindingContext.Builder addAll(BindingContext context) {
        context.identifiers().forEach(id -> this.bindings.put((String)id, () -> context.lookup((String)id).get()));
        this.modules.addAll(context.modules());
        return this;
    }

    @Override
    public BindingContext.Builder addModule(ExpressionModule expressionModule) {
        this.modules.add(expressionModule);
        return this;
    }

    @Override
    public BindingContext build() {
        return new BindingContextImplementation(this.bindings, this.modules);
    }

    private class BindingContextImplementation
    implements BindingContext {
        private Map<String, Supplier<TypedValue>> bindings;
        private List<ExpressionModule> modules;

        private BindingContextImplementation(Map<String, Supplier<TypedValue>> bindings, List<ExpressionModule> modules) {
            this.bindings = Collections.unmodifiableMap(new HashMap<String, Supplier<TypedValue>>(bindings));
            this.modules = Collections.unmodifiableList(new ArrayList<ExpressionModule>(modules));
        }

        @Override
        public Collection<Binding> bindings() {
            return this.bindings.entrySet().stream().map(entry -> new Binding((String)entry.getKey(), entry.getValue() != null ? (TypedValue)((Supplier)entry.getValue()).get() : null)).collect(Collectors.toList());
        }

        @Override
        public Collection<String> identifiers() {
            return this.bindings.keySet();
        }

        @Override
        public Optional<TypedValue> lookup(String identifier) {
            Supplier<TypedValue> supplier = this.bindings.get(identifier);
            return supplier != null ? Optional.ofNullable(supplier.get()) : Optional.empty();
        }

        @Override
        public Collection<ExpressionModule> modules() {
            return this.modules;
        }
    }
}

