/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.CompositeSourcePolicy;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import reactor.core.publisher.Mono;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyStateHandler policyStateHandler;
    @Inject
    private StreamingManager streamingManager;
    private Collection<OperationPolicyParametersTransformer> operationPolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyParametersTransformer> sourcePolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories = Collections.emptyList();
    private Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories = Collections.emptyList();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;

    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        PolicyPointcutParameters sourcePointcutParameters = this.createSourcePointcutParameters(source, sourceEvent);
        List<Policy> parameterizedPolicies = this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return event -> Mono.from(MessageProcessors.process(event, flowExecutionProcessor)).defaultIfEmpty(CoreEvent.builder(sourceEvent).message(Message.of(null)).build()).map(flowExecutionResult -> Either.right(new SourcePolicySuccessResult((CoreEvent)flowExecutionResult, () -> messageSourceResponseParametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply((CoreEvent)flowExecutionResult), messageSourceResponseParametersProcessor))).onErrorResume(Exception.class, e -> {
                MessagingException messagingException = e instanceof MessagingException ? (MessagingException)e : new MessagingException(event, (Throwable)e, (Component)((Object)flowExecutionProcessor));
                return Mono.just(Either.left(new SourcePolicyFailureResult(messagingException, () -> messageSourceResponseParametersProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent()))));
            });
        }
        return new CompositeSourcePolicy(parameterizedPolicies, this.lookupSourceParametersTransformer(source.getLocation().getComponentIdentifier().getIdentifier()), this.sourcePolicyProcessorFactory, flowExecutionProcessor, messageSourceResponseParametersProcessor);
    }

    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, Map<String, Object> operationParameters, OperationExecutionFunction operationExecutionFunction) {
        PolicyPointcutParameters operationPointcutParameters = this.createOperationPointcutParameters(operation, operationParameters);
        List<Policy> parameterizedPolicies = this.policyProvider.findOperationParameterizedPolicies(operationPointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return operationEvent -> operationExecutionFunction.execute(operationParameters, operationEvent);
        }
        return new CompositeOperationPolicy(parameterizedPolicies, this.lookupOperationParametersTransformer(operation.getLocation().getComponentIdentifier().getIdentifier()), this.operationPolicyProcessorFactory, () -> operationParameters, operationExecutionFunction, this.streamingManager);
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.operationPolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.sourcePolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory(this.policyStateHandler);
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory(this.policyStateHandler);
        MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
        this.policyProvider = registry.lookupLocalObjects(PolicyProvider.class).stream().findFirst().orElse(new NullPolicyProvider());
        this.sourcePolicyParametersTransformerCollection = registry.lookupObjects(SourcePolicyParametersTransformer.class);
        this.operationPolicyParametersTransformerCollection = registry.lookupObjects(OperationPolicyParametersTransformer.class);
        this.sourcePointcutFactories = registry.lookupObjects(SourcePolicyPointcutParametersFactory.class);
        this.operationPointcutFactories = registry.lookupObjects(OperationPolicyPointcutParametersFactory.class);
    }

    private PolicyPointcutParameters createSourcePointcutParameters(Component source, CoreEvent sourceEvent) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        return this.createPointcutParameters(source, SourcePolicyPointcutParametersFactory.class, this.sourcePointcutFactories, factory -> factory.supportsSourceIdentifier(sourceIdentifier), factory -> factory.createPolicyPointcutParameters(source, sourceEvent.getMessage().getAttributes()));
    }

    private PolicyPointcutParameters createOperationPointcutParameters(Component operation, Map<String, Object> operationParameters) {
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        return this.createPointcutParameters(operation, OperationPolicyPointcutParametersFactory.class, this.operationPointcutFactories, factory -> factory.supportsOperationIdentifier(operationIdentifier), factory -> factory.createPolicyPointcutParameters(operation, operationParameters));
    }

    private <T> PolicyPointcutParameters createPointcutParameters(Component component, Class<T> factoryType, Collection<T> factories, Predicate<T> factoryFilter, Function<T, PolicyPointcutParameters> policyPointcutParametersCreationFunction) {
        Object found = null;
        for (T factory : factories) {
            if (!factoryFilter.test(factory)) continue;
            if (found != null) {
                this.throwMoreThanOneFactoryFoundException(component.getLocation().getComponentIdentifier().getIdentifier(), factoryType);
            }
            found = factory;
        }
        if (found == null) {
            return new PolicyPointcutParameters(component);
        }
        return policyPointcutParametersCreationFunction.apply(found);
    }

    private PolicyPointcutParameters throwMoreThanOneFactoryFoundException(ComponentIdentifier sourceIdentifier, Class factoryClass) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("More than one %s for component %s was found. There should be only one.", factoryClass.getName(), sourceIdentifier)));
    }

    @Override
    public void disposePoliciesResources(String executionIdentifier) {
        this.policyStateHandler.destroyState(executionIdentifier);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

