/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.time.Duration;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ProactorStreamProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory {
    protected static final long STREAM_PAYLOAD_BLOCKING_IO_THRESHOLD = Long.getLong(SYSTEM_PROPERTY_PREFIX + "STREAM_PAYLOAD_BLOCKING_IO_THRESHOLD", DataUnit.KB.toBytes(16));

    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new ProactorStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), this.getCpuLightSchedulerSupplier(muleContext, schedulersNamePrefix), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.resolveParallelism(), this.getMaxConcurrency());
    }

    @Override
    protected int resolveParallelism() {
        if (this.getMaxConcurrency() == Integer.MAX_VALUE) {
            return Math.max(CORES / this.getSubscriberCount(), 1);
        }
        return Math.min(CORES, this.maxFactor(Float.max((float)this.getMaxConcurrency() / (float)this.getSubscriberCount(), 1.0f)));
    }

    private int maxFactor(float test) {
        if (test % 0.0f == 0.0f) {
            for (int i = CORES; i > 1; --i) {
                if (test % (float)i != 0.0f) continue;
                return i;
            }
        }
        return 1;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return ProactorStreamProcessingStrategy.class;
    }

    static class ProactorStreamProcessingStrategy
    extends ReactorStreamProcessingStrategyFactory.ReactorStreamProcessingStrategy {
        private static Logger LOGGER = LoggerFactory.getLogger(ProactorStreamProcessingStrategy.class);
        private static int SCHEDULER_BUSY_RETRY_INTERVAL_MS = 2;
        private Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier;
        private Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier;
        private org.mule.runtime.api.scheduler.Scheduler blockingScheduler;
        private org.mule.runtime.api.scheduler.Scheduler cpuIntensiveScheduler;

        public ProactorStreamProcessingStrategy(Supplier<org.mule.runtime.api.scheduler.Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier, int parrelism, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, cpuLightSchedulerSupplier, parrelism, maxConcurrency);
            this.blockingSchedulerSupplier = blockingSchedulerSupplier;
            this.cpuIntensiveSchedulerSupplier = cpuIntensiveSchedulerSupplier;
        }

        @Override
        public void start() throws MuleException {
            super.start();
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
            this.cpuIntensiveScheduler = this.cpuIntensiveSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
            if (this.cpuIntensiveScheduler != null) {
                this.cpuIntensiveScheduler.stop();
            }
            super.stop();
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING || processor.getProcessingType() == ReactiveProcessor.ProcessingType.IO_RW) {
                return this.proactor(processor, this.blockingScheduler);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE) {
                return this.proactor(processor, this.cpuIntensiveScheduler);
            }
            return super.onProcessor(processor);
        }

        private ReactiveProcessor proactor(ReactiveProcessor processor, org.mule.runtime.api.scheduler.Scheduler scheduler) {
            Scheduler publishOnScheduler = Schedulers.fromExecutorService(this.decorateScheduler(this.getCpuLightScheduler()));
            Scheduler subscribeOnScheduler = Schedulers.fromExecutorService(this.decorateScheduler(scheduler));
            return publisher -> Flux.from(publisher).flatMap(event -> {
                if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.IO_RW && !this.scheduleIoRwEvent((CoreEvent)event)) {
                    return Flux.just(event).transform(processor);
                }
                return this.scheduleProcessor(processor, publishOnScheduler, subscribeOnScheduler, scheduler.getName(), (CoreEvent)event);
            }, Math.max(this.maxConcurrency / (this.getParallelism() * this.subscribers), 1));
        }

        private boolean scheduleIoRwEvent(CoreEvent event) {
            return event.getMessage().getPayload().getDataType().isStreamType() && event.getMessage().getPayload().getLength().orElse(Long.MAX_VALUE) > STREAM_PAYLOAD_BLOCKING_IO_THRESHOLD;
        }

        private Publisher<CoreEvent> scheduleProcessor(ReactiveProcessor processor, Scheduler publishOnScheduler, Scheduler subscribeOnScheduler, String subscribeOnSchedulerName, CoreEvent event) {
            return Flux.just(event).transform(processor).publishOn(publishOnScheduler).subscribeOn(subscribeOnScheduler).doOnError(RejectedExecutionException.class, throwable -> LOGGER.trace("Shared scheduler " + subscribeOnSchedulerName + " is busy.  Scheduling of the current event will be retried after " + SCHEDULER_BUSY_RETRY_INTERVAL_MS + "ms.")).retryWhen(errors -> errors.flatMap(error -> Mono.delay(Duration.ofMillis(SCHEDULER_BUSY_RETRY_INTERVAL_MS), Schedulers.fromExecutorService(this.getCpuLightScheduler()))));
        }
    }
}

