/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.policies;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.retry.BackoffDelay;
import reactor.retry.Retry;
import reactor.retry.RetryExhaustedException;

public class SimpleRetryPolicy
implements RetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRetryPolicy.class);
    private static final Scheduler TRANSACTIONAL_RETRY_SCHEDULER = new TransactionalRetryScheduler();
    protected RetryCounter retryCounter;
    private volatile int count = 2;
    private volatile Duration frequency = Duration.ofMillis(2000L);

    public SimpleRetryPolicy(long frequency, int retryCount) {
        this.frequency = Duration.ofMillis(frequency);
        this.count = retryCount;
        this.retryCounter = new RetryCounter();
    }

    @Override
    public <T> Publisher<T> applyPolicy(Publisher<T> publisher, Predicate<Throwable> shouldRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction) {
        return Mono.from(publisher).onErrorResume(e -> {
            if (shouldRetry.test((Throwable)e)) {
                Retry retry = Retry.onlyIf(ctx -> shouldRetry.test(Exceptions.unwrap(ctx.exception()))).backoff(ctx -> new BackoffDelay(this.frequency, Duration.ZERO, Duration.ZERO));
                if (this.count != -1) {
                    retry = retry.retryMax(this.count - 1);
                }
                Mono retryMono = Mono.from(publisher).retryWhen((Function<Flux<Throwable>, Publisher<?>>)retry).doOnError(e2 -> onExhausted.accept(Exceptions.unwrap(e2))).onErrorMap(RetryExhaustedException.class, e2 -> (Throwable)errorFunction.apply(Exceptions.unwrap(e2.getCause())));
                if (TransactionCoordination.isTransactionActive()) {
                    retry.withBackoffScheduler(TRANSACTIONAL_RETRY_SCHEDULER);
                    retryMono = Mono.delay(this.frequency, TRANSACTIONAL_RETRY_SCHEDULER).then(Mono.just(retryMono.block()));
                } else {
                    retryMono = Mono.delay(this.frequency).then(retryMono);
                }
                return retryMono;
            }
            e = Exceptions.unwrap(e);
            onExhausted.accept((Throwable)e);
            return Mono.error((Throwable)errorFunction.apply((Throwable)e));
        });
    }

    @Override
    public PolicyStatus applyPolicy(Throwable cause) {
        if (this.isExhausted() || !this.isApplicableTo(cause)) {
            return PolicyStatus.policyExhausted(cause);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Waiting for " + this.frequency.toMillis() + "ms before reconnecting. Failed attempt " + (this.retryCounter.current().get() + 1) + " of " + (this.count != -1 ? String.valueOf(this.count) : "unlimited"));
        }
        try {
            this.retryCounter.current().getAndIncrement();
            Thread.sleep(this.frequency.toMillis());
            return PolicyStatus.policyOk();
        }
        catch (InterruptedException e) {
            return PolicyStatus.policyExhausted(e);
        }
    }

    protected boolean isApplicableTo(Throwable cause) {
        return true;
    }

    protected boolean isExhausted() {
        return this.count != -1 && this.retryCounter.current().get() >= this.count;
    }

    private static class TransactionalRetryScheduler
    implements Scheduler {
        private final Scheduler delegate = Schedulers.immediate();

        private TransactionalRetryScheduler() {
        }

        @Override
        public Disposable schedule(Runnable task) {
            return this.delegate.schedule(task);
        }

        @Override
        public Disposable schedule(Runnable task, long delay, TimeUnit unit) {
            try {
                Thread.sleep(unit.toMillis(delay));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.schedule(task);
        }

        @Override
        public Disposable schedulePeriodically(Runnable task, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.schedulePeriodically(task, initialDelay, period, unit);
        }

        @Override
        public long now(TimeUnit unit) {
            return this.delegate.now(unit);
        }

        @Override
        public Scheduler.Worker createWorker() {
            return this.delegate.createWorker();
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public boolean isDisposed() {
            return this.delegate.isDisposed();
        }
    }

    protected static class RetryCounter
    extends ThreadLocal<AtomicInteger> {
        protected RetryCounter() {
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    }
}

