/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.graph.DirectedMultigraph;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.graph.TransformationEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationGraph
extends DirectedMultigraph<DataType, TransformationEdge> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Set<Converter> registeredConverters = new HashSet<Converter>();

    public TransformationGraph() {
        super(TransformationEdge.class);
    }

    public void addConverter(Converter converter) {
        if (this.registeredConverters.contains(converter)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Attempting to register an already registered converter: " + converter);
            }
            return;
        }
        DataType returnDataType = converter.getReturnDataType();
        if (!this.containsVertex(returnDataType)) {
            this.addVertex(returnDataType);
        }
        for (DataType sourceDataType : converter.getSourceDataTypes()) {
            if (!this.containsVertex(sourceDataType)) {
                this.addVertex(sourceDataType);
            }
            this.addEdge(sourceDataType, returnDataType, new TransformationEdge(converter));
        }
        this.registeredConverters.add(converter);
    }

    public void removeConverter(Converter converter) {
        if (!this.registeredConverters.contains(converter)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Attempt to remove an unregistered converter: " + converter);
            }
            return;
        }
        DataType returnDataType = converter.getReturnDataType();
        for (DataType sourceDataType : converter.getSourceDataTypes()) {
            Set allEdges = this.getAllEdges(sourceDataType, returnDataType);
            for (TransformationEdge edge : allEdges) {
                if (edge.getConverter() != converter) continue;
                DataType source = (DataType)this.getEdgeSource(edge);
                DataType target = (DataType)this.getEdgeTarget(edge);
                this.removeEdge(edge);
                if (this.inDegreeOf(source) == 0 && this.outDegreeOf(source) == 0) {
                    this.removeVertex(source);
                }
                if (this.inDegreeOf(target) != 0 || this.outDegreeOf(target) != 0) continue;
                this.removeVertex(target);
            }
        }
        this.registeredConverters.remove(converter);
    }

    List<DataType> getSuperVertexes(DataType vertex) {
        if (super.containsVertex((Object)vertex)) {
            return Arrays.asList(vertex);
        }
        return this.vertexSet().stream().filter(graphVertex -> graphVertex.isCompatibleWith(vertex)).collect(Collectors.toList());
    }

    List<DataType> getSubVertexes(DataType vertex) {
        if (super.containsVertex((Object)vertex)) {
            return Arrays.asList(vertex);
        }
        return this.vertexSet().stream().filter(vertex::isCompatibleWith).collect(Collectors.toList());
    }

    boolean containsVertexOrSuper(DataType vertex) {
        return !this.getSuperVertexes(vertex).isEmpty();
    }

    boolean containsVertexOrSub(DataType vertex) {
        return !this.getSubVertexes(vertex).isEmpty();
    }
}

