/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.plugin.DuplicateExportedPackageException;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.internal.plugin.PluginResolutionError;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;

public class BundlePluginDependenciesResolver
implements PluginDependenciesResolver {
    private final ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory;

    public BundlePluginDependenciesResolver(ArtifactDescriptorFactory<ArtifactPluginDescriptor> artifactDescriptorFactory) {
        this.artifactDescriptorFactory = artifactDescriptorFactory;
    }

    @Override
    public List<ArtifactPluginDescriptor> resolve(Set<ArtifactPluginDescriptor> providedPluginDescriptors, List<ArtifactPluginDescriptor> descriptors) {
        List<ArtifactPluginDescriptor> resolvedPlugins = this.resolvePluginsDependencies(descriptors);
        List<ArtifactPluginDescriptor> filteredPluginDescriptors = this.getArtifactPluginDescriptors(providedPluginDescriptors, resolvedPlugins);
        this.verifyPluginExportedPackages(filteredPluginDescriptors);
        return filteredPluginDescriptors;
    }

    private List<ArtifactPluginDescriptor> getArtifactPluginDescriptors(Set<ArtifactPluginDescriptor> domainPlugins, List<ArtifactPluginDescriptor> resolvedPlugins) {
        ArrayList<ArtifactPluginDescriptor> filteredPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor appPluginDescriptor : resolvedPlugins) {
            Optional<ArtifactPluginDescriptor> pluginDescriptor = this.findPlugin(domainPlugins, appPluginDescriptor.getBundleDescriptor());
            if (!pluginDescriptor.isPresent()) {
                filteredPluginDescriptors.add(appPluginDescriptor);
                continue;
            }
            if (BundleDescriptorUtils.isCompatibleVersion(pluginDescriptor.get().getBundleDescriptor().getVersion(), appPluginDescriptor.getBundleDescriptor().getVersion())) continue;
            throw new IllegalStateException(String.format("Incompatible version of plugin '%s' (%s:%s) found. Artifact requires version '%s' but context provides version '%s'", appPluginDescriptor.getName(), appPluginDescriptor.getBundleDescriptor().getGroupId(), appPluginDescriptor.getBundleDescriptor().getArtifactId(), appPluginDescriptor.getBundleDescriptor().getVersion(), pluginDescriptor.get().getBundleDescriptor().getVersion()));
        }
        return filteredPluginDescriptors;
    }

    private Optional<ArtifactPluginDescriptor> findPlugin(Set<ArtifactPluginDescriptor> appPlugins, BundleDescriptor bundleDescriptor) {
        for (ArtifactPluginDescriptor appPlugin : appPlugins) {
            if (!appPlugin.getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) || !appPlugin.getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())) continue;
            return Optional.of(appPlugin);
        }
        return Optional.empty();
    }

    private List<ArtifactPluginDescriptor> resolvePluginsDependencies(List<ArtifactPluginDescriptor> descriptors) {
        Set<BundleDescriptor> knownPlugins = descriptors.stream().map(ArtifactDescriptor::getBundleDescriptor).collect(Collectors.toSet());
        descriptors = this.getArtifactsWithDependencies(descriptors, knownPlugins);
        ArrayList<ArtifactPluginDescriptor> sortedDescriptors = new ArrayList<ArtifactPluginDescriptor>(descriptors);
        sortedDescriptors.sort((d1, d2) -> d1.getName().compareTo(d2.getName()));
        LinkedList<ArtifactPluginDescriptor> resolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
        LinkedList<ArtifactPluginDescriptor> unresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>(sortedDescriptors);
        boolean continueResolution = true;
        while (continueResolution) {
            int initialResolvedCount = resolvedPlugins.size();
            LinkedList<ArtifactPluginDescriptor> pendingUnresolvedPlugins = new LinkedList<ArtifactPluginDescriptor>();
            for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
                if (this.isResolvedPlugin(unresolvedPlugin, resolvedPlugins)) {
                    this.sanitizeExportedPackages(unresolvedPlugin, resolvedPlugins);
                    resolvedPlugins.add(unresolvedPlugin);
                    continue;
                }
                pendingUnresolvedPlugins.add(unresolvedPlugin);
            }
            unresolvedPlugins = pendingUnresolvedPlugins;
            continueResolution = resolvedPlugins.size() > initialResolvedCount;
        }
        if (unresolvedPlugins.size() != 0) {
            throw new PluginResolutionError(BundlePluginDependenciesResolver.createResolutionErrorMessage(unresolvedPlugins, resolvedPlugins));
        }
        return resolvedPlugins;
    }

    private void verifyPluginExportedPackages(List<ArtifactPluginDescriptor> plugins) {
        HashMap<String, List<String>> exportedPackages = new HashMap<String, List<String>>();
        boolean error = false;
        for (ArtifactPluginDescriptor plugin : plugins) {
            for (String packageName : plugin.getClassLoaderModel().getExportedPackages()) {
                LinkedList<String> exportedOn = (LinkedList<String>)exportedPackages.get(packageName);
                if (exportedOn == null) {
                    exportedOn = new LinkedList<String>();
                    exportedPackages.put(packageName, exportedOn);
                } else {
                    error = true;
                }
                exportedOn.add(plugin.getName());
            }
        }
        if (error) {
            throw new DuplicateExportedPackageException(exportedPackages);
        }
    }

    private List<ArtifactPluginDescriptor> getArtifactsWithDependencies(List<ArtifactPluginDescriptor> pluginDescriptors, Set<BundleDescriptor> visited) {
        ArrayList<ArtifactPluginDescriptor> pluginDescriptorsWithDependences = new ArrayList<ArtifactPluginDescriptor>();
        pluginDescriptorsWithDependences.addAll(pluginDescriptors);
        if (!pluginDescriptors.isEmpty()) {
            ArrayList<ArtifactPluginDescriptor> foundDependencies = new ArrayList<ArtifactPluginDescriptor>();
            pluginDescriptors.stream().filter(pluginDescriptor -> !pluginDescriptor.getClassLoaderModel().getDependencies().isEmpty()).filter(pluginDescriptor -> pluginDescriptor.getBundleDescriptor().isPlugin()).forEach(pluginDescriptor -> pluginDescriptor.getClassLoaderModel().getDependencies().forEach(dependency -> {
                if (this.isPlugin((BundleDependency)dependency) && !this.isResolvedDependency(visited, dependency.getDescriptor())) {
                    if (dependency.getBundleUri() == null) {
                        throw new PluginResolutionError(String.format("Bundle URL should have been resolved for %s.", dependency.getDescriptor()));
                    }
                    File mulePluginLocation = new File(dependency.getBundleUri());
                    ArtifactPluginDescriptor artifactPluginDescriptor = this.artifactDescriptorFactory.create(mulePluginLocation, Optional.empty());
                    artifactPluginDescriptor.setBundleDescriptor(dependency.getDescriptor());
                    foundDependencies.add(artifactPluginDescriptor);
                    visited.add(dependency.getDescriptor());
                }
            }));
            pluginDescriptorsWithDependences.addAll(this.getArtifactsWithDependencies(foundDependencies, visited));
        }
        return pluginDescriptorsWithDependences;
    }

    private boolean isPlugin(BundleDependency dependency) {
        return dependency.getDescriptor().isPlugin();
    }

    private void sanitizeExportedPackages(ArtifactPluginDescriptor pluginDescriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        Set<String> packagesExportedByDependencies = this.findDependencyPackageClosure(pluginDescriptor.getClassLoaderModel().getDependencies(), resolvedPlugins);
        ClassLoaderModel originalClassLoaderModel = pluginDescriptor.getClassLoaderModel();
        HashSet<String> exportedClassPackages = new HashSet<String>(originalClassLoaderModel.getExportedPackages());
        exportedClassPackages.removeAll(packagesExportedByDependencies);
        pluginDescriptor.setClassLoaderModel(this.createBuilderWithoutExportedPackages(originalClassLoaderModel).exportingPackages(exportedClassPackages).build());
    }

    private ClassLoaderModel.ClassLoaderModelBuilder createBuilderWithoutExportedPackages(ClassLoaderModel originalClassLoaderModel) {
        ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder = new ClassLoaderModel.ClassLoaderModelBuilder().dependingOn(originalClassLoaderModel.getDependencies()).exportingPrivilegedPackages(originalClassLoaderModel.getPrivilegedExportedPackages(), originalClassLoaderModel.getPrivilegedArtifacts()).exportingResources(originalClassLoaderModel.getExportedResources());
        for (URL url : originalClassLoaderModel.getUrls()) {
            classLoaderModelBuilder.containing(url);
        }
        return classLoaderModelBuilder;
    }

    private Set<String> findDependencyPackageClosure(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        HashSet<String> exportedPackages = new HashSet<String>();
        for (BundleDependency pluginDependency : pluginDependencies) {
            Optional<String> classifier = pluginDependency.getDescriptor().getClassifier();
            if (!classifier.isPresent() || !"mule-plugin".equals(classifier.get())) continue;
            ArtifactPluginDescriptor dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(pluginDependency, resolvedPlugins);
            exportedPackages.addAll(dependencyDescriptor.getClassLoaderModel().getExportedPackages());
            exportedPackages.addAll(this.findDependencyPackageClosure(dependencyDescriptor.getClassLoaderModel().getDependencies(), resolvedPlugins));
        }
        return exportedPackages;
    }

    protected static String createResolutionErrorMessage(List<ArtifactPluginDescriptor> unresolvedPlugins, List<ArtifactPluginDescriptor> resolvedPlugins) {
        StringBuilder builder = new StringBuilder("Unable to resolve plugin dependencies:");
        for (ArtifactPluginDescriptor unresolvedPlugin : unresolvedPlugins) {
            builder.append("\nPlugin: ").append(unresolvedPlugin.getName()).append(" missing dependencies:");
            ArrayList<BundleDependency> missingDependencies = new ArrayList<BundleDependency>();
            for (BundleDependency dependency : unresolvedPlugin.getClassLoaderModel().getDependencies()) {
                ArtifactPluginDescriptor dependencyDescriptor;
                Optional<String> classifierOptional = dependency.getDescriptor().getClassifier();
                if (!classifierOptional.isPresent() || !"mule-plugin".equals(classifierOptional.get()) || (dependencyDescriptor = BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins)) != null) continue;
                missingDependencies.add(dependency);
            }
            builder.append(missingDependencies);
        }
        return builder.toString();
    }

    private boolean isResolvedDependency(Set<BundleDescriptor> visited, BundleDescriptor descriptor) {
        for (BundleDescriptor resolvedDependency : visited) {
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedDependency, descriptor)) continue;
            return true;
        }
        return false;
    }

    private boolean isResolvedPlugin(ArtifactPluginDescriptor descriptor, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean isResolved = descriptor.getClassLoaderModel().getDependencies().isEmpty();
        if (!isResolved && this.hasPluginDependenciesResolved(descriptor.getClassLoaderModel().getDependencies(), resolvedPlugins)) {
            isResolved = true;
        }
        return isResolved;
    }

    private static ArtifactPluginDescriptor findArtifactPluginDescriptor(BundleDependency bundleDependency, List<ArtifactPluginDescriptor> resolvedPlugins) {
        ArtifactPluginDescriptor result = null;
        for (ArtifactPluginDescriptor resolvedPlugin : resolvedPlugins) {
            BundleDescriptor resolvedBundleDescriptor = resolvedPlugin.getBundleDescriptor();
            if (!BundlePluginDependenciesResolver.isResolvedDependency(resolvedBundleDescriptor, bundleDependency.getDescriptor())) continue;
            result = resolvedPlugin;
            break;
        }
        return result;
    }

    private static boolean isResolvedDependency(BundleDescriptor availableBundleDescriptor, BundleDescriptor expectedBundleDescriptor) {
        return availableBundleDescriptor.getArtifactId().equals(expectedBundleDescriptor.getArtifactId()) && availableBundleDescriptor.getGroupId().equals(expectedBundleDescriptor.getGroupId()) && BundleDescriptorUtils.isCompatibleVersion(availableBundleDescriptor.getVersion(), expectedBundleDescriptor.getVersion());
    }

    private boolean hasPluginDependenciesResolved(Set<BundleDependency> pluginDependencies, List<ArtifactPluginDescriptor> resolvedPlugins) {
        boolean resolvedDependency = true;
        for (BundleDependency dependency : pluginDependencies) {
            if (!dependency.getDescriptor().isPlugin() || BundlePluginDependenciesResolver.findArtifactPluginDescriptor(dependency, resolvedPlugins) != null) continue;
            resolvedDependency = false;
            break;
        }
        return resolvedDependency;
    }
}

