/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

final class DefaultConnectionProviderFactory<C>
implements ConnectionProviderFactory<C> {
    private final Class<? extends ConnectionProvider> providerClass;
    private final ClassLoader extensionClassLoader;

    DefaultConnectionProviderFactory(Class<?> providerClass, ClassLoader extensionClassLoader) {
        this.extensionClassLoader = extensionClassLoader;
        if (!ConnectionProvider.class.isAssignableFrom(providerClass)) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Class '%s' was specified as a connection provider but it doesn't implement the '%s' interface", providerClass.getName(), ConnectionProvider.class.getName()));
        }
        IntrospectionUtils.checkInstantiable(providerClass, new ReflectionCache());
        this.providerClass = providerClass;
    }

    @Override
    public ConnectionProvider<C> newInstance() {
        try {
            return ClassUtils.withContextClassLoader(this.extensionClassLoader, this.providerClass::newInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create connection provider of type " + this.providerClass.getName()), (Throwable)e);
        }
    }

    @Override
    public Class<? extends ConnectionProvider> getObjectType() {
        return this.providerClass;
    }
}

