/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.privileged.component.AnnotatedObjectInvocationHandler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class TypeAwareConfigurationFactory
implements ConfigurationFactory {
    private final Class<?> configurationType;
    private final ClassLoader extensionClassLoader;

    public TypeAwareConfigurationFactory(Class<?> configurationType, ClassLoader extensionClassLoader) {
        Preconditions.checkArgument(configurationType != null, "configuration type cannot be null");
        Preconditions.checkArgument(extensionClassLoader != null, "extensionClassLoader type cannot be null");
        IntrospectionUtils.checkInstantiable(configurationType, new ReflectionCache());
        this.configurationType = ClassUtils.withContextClassLoader(extensionClassLoader, () -> AnnotatedObjectInvocationHandler.addAnnotationsToClass(configurationType));
        this.extensionClassLoader = extensionClassLoader;
    }

    @Override
    public Object newInstance() {
        try {
            return ClassUtils.withContextClassLoader(this.extensionClassLoader, this.configurationType::newInstance);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not instantiate configuration of type " + this.configurationType.getName()), (Throwable)e);
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.configurationType;
    }
}

