/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader.type.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.extension.api.soap.SoapServiceProvider;
import org.mule.runtime.extension.api.soap.annotation.Soap;
import org.mule.runtime.extension.api.soap.annotation.SoapMessageDispatcherProviders;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.MessageDispatcherProviderTypeWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapComponentWrapper;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;

public class SoapExtensionTypeWrapper<T>
extends SoapComponentWrapper {
    private ClassTypeLoader typeLoader;

    public SoapExtensionTypeWrapper(Class<T> extensionType, ClassTypeLoader typeLoader) {
        super(extensionType, typeLoader);
        this.typeLoader = typeLoader;
    }

    public List<SoapServiceProviderWrapper> getSoapServiceProviders() {
        ImmutableList.Builder serviceProviders = ImmutableList.builder();
        if (this.isAssignableTo(SoapServiceProvider.class)) {
            serviceProviders.add((Object)new SoapServiceProviderWrapper((Class<? extends SoapServiceProvider>)this.getDeclaringClass().get(), this.typeLoader));
        }
        this.getAnnotation(Soap.class).ifPresent(soap -> Arrays.stream(soap.value()).forEach(sp2 -> serviceProviders.add((Object)new SoapServiceProviderWrapper((Class<? extends SoapServiceProvider>)sp2, this.typeLoader))));
        return serviceProviders.build();
    }

    public List<MessageDispatcherProviderTypeWrapper> getDispatcherProviders() {
        ImmutableList.Builder transportProviders = ImmutableList.builder();
        Optional<SoapMessageDispatcherProviders> customTransport = this.getAnnotation(SoapMessageDispatcherProviders.class);
        customTransport.ifPresent(ct -> transportProviders.addAll((Iterable)Arrays.stream(ct.value()).map(providerClass -> new MessageDispatcherProviderTypeWrapper((Class<?>)providerClass, this.typeLoader)).collect(Collectors.toList())));
        return transportProviders.build();
    }
}

