/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.api.annotation.NoImplement;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ToolingApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.artifact.DeployableArtifactWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultDomainFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.tooling.api.ToolingService;
import org.mule.runtime.module.tooling.api.connectivity.ConnectivityTestingServiceBuilder;
import org.mule.runtime.module.tooling.internal.ArtifactFileWriter;
import org.mule.runtime.module.tooling.internal.DefaultConnectivityTestingServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoImplement
public class DefaultToolingService
implements ToolingService {
    private static final String MULE_TMP_FILENAME = "tmp";
    private static final String TOOLING_APPS_FOLDER = "tooling";
    private static final String TOOLING_PREFIX = "tooling";
    private static final String APPLICATION = "application";
    private static final String DOMAIN = "domain";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DomainRepository domainRepository;
    private final DefaultDomainFactory domainFactory;
    private final DefaultApplicationFactory applicationFactory;
    private final ToolingApplicationDescriptorFactory applicationDescriptorFactory;
    private File toolingServiceAppsFolder;
    private ArtifactFileWriter artifactFileWriter;

    public DefaultToolingService(DomainRepository domainRepository, DefaultDomainFactory domainFactory, DefaultApplicationFactory applicationFactory, ToolingApplicationDescriptorFactory applicationDescriptorFactory) {
        this.domainRepository = domainRepository;
        this.domainFactory = domainFactory;
        this.applicationFactory = applicationFactory;
        this.applicationDescriptorFactory = applicationDescriptorFactory;
    }

    @Override
    public ConnectivityTestingServiceBuilder newConnectivityTestingServiceBuilder() {
        return new DefaultConnectivityTestingServiceBuilder(this.applicationFactory);
    }

    @Override
    public Application createApplication(File applicationLocation) throws IOException {
        File toolingApplicationContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(APPLICATION), applicationLocation);
        try {
            return this.doCreateApplication(toolingApplicationContent, Optional.empty());
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingApplicationContent);
            throw t;
        }
    }

    @Override
    public Application createApplication(File applicationLocation, Optional<Properties> deploymentProperties) throws IOException {
        File toolingApplicationContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(APPLICATION), applicationLocation);
        try {
            return this.doCreateApplication(toolingApplicationContent, deploymentProperties);
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingApplicationContent);
            throw t;
        }
    }

    private Application doCreateApplication(File toolingApplicationContent, Optional<Properties> deploymentProperties) throws IOException {
        Optional<Properties> mergedDeploymentProperties = Optional.of(DefaultToolingService.createDeploymentProperties(deploymentProperties));
        MuleApplicationModel.MuleApplicationModelBuilder applicationArtifactModelBuilder = this.applicationDescriptorFactory.createArtifactModelBuilder(toolingApplicationContent);
        String domainName = mergedDeploymentProperties.get().getProperty("_muleToolingDeploymentDomainNameRef");
        if (domainName != null) {
            Domain domain = this.domainRepository.getDomain(domainName);
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Domain '%s' is expected to be deployed", domainName));
            }
            MuleArtifactLoaderDescriptor classLoaderModelDescriptorLoader = applicationArtifactModelBuilder.getClassLoaderModelDescriptorLoader();
            HashMap<String, Object> extendedAttributes = new HashMap<String, Object>(classLoaderModelDescriptorLoader.getAttributes());
            extendedAttributes.put("_classLoaderModelMavenReactorResolver", new DomainMavenReactorResolver(domain.getLocation(), ((DomainDescriptor)domain.getDescriptor()).getBundleDescriptor()));
            applicationArtifactModelBuilder.withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor(classLoaderModelDescriptorLoader.getId(), extendedAttributes));
            ApplicationDescriptor applicationDescriptor = this.applicationDescriptorFactory.createArtifact(toolingApplicationContent, mergedDeploymentProperties, (MuleApplicationModel)applicationArtifactModelBuilder.build());
            applicationDescriptor.setDomainName(domain.getArtifactName());
            return new ToolingApplicationWrapper(this.doCreateApplication(applicationDescriptor));
        }
        return new ToolingApplicationWrapper(this.doCreateApplication((ApplicationDescriptor)this.applicationDescriptorFactory.create(toolingApplicationContent, mergedDeploymentProperties)));
    }

    @Override
    public Application createApplication(byte[] appContent) throws IOException {
        File toolingApplicationContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(APPLICATION), appContent);
        try {
            return this.doCreateApplication(toolingApplicationContent, Optional.empty());
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingApplicationContent);
            throw t;
        }
    }

    @Override
    public Application createApplication(byte[] appContent, Optional<Properties> deploymentProperties) throws IOException {
        File toolingApplicationContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(APPLICATION), appContent);
        try {
            return this.doCreateApplication(toolingApplicationContent, deploymentProperties);
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingApplicationContent);
            throw t;
        }
    }

    private Application doCreateApplication(ApplicationDescriptor applicationDescriptor) throws IOException {
        Application application = this.applicationFactory.createArtifact(applicationDescriptor);
        application.install();
        application.lazyInit();
        application.start();
        return application;
    }

    @Override
    public Domain createDomain(File domainLocation) throws IOException {
        File toolingDomainContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(DOMAIN), domainLocation);
        try {
            return this.doCreateDomain(toolingDomainContent);
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingDomainContent);
            throw t;
        }
    }

    @Override
    public Domain createDomain(byte[] domainContent) throws IOException {
        File toolingDomainContent = this.artifactFileWriter.writeContent(this.getUniqueIdString(DOMAIN), domainContent);
        try {
            return this.doCreateDomain(toolingDomainContent);
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)toolingDomainContent);
            throw t;
        }
    }

    private Domain doCreateDomain(File toolingDomainContent) throws IOException {
        Domain domain = (Domain)this.domainFactory.createArtifact(toolingDomainContent, (Optional)Optional.of(DefaultToolingService.createDeploymentProperties()));
        domain.install();
        domain.lazyInit();
        domain.start();
        return new ToolingDomainWrapper(domain);
    }

    private static Properties createDeploymentProperties() {
        Properties properties = new Properties();
        return DefaultToolingService.createDeploymentProperties(Optional.of(properties));
    }

    private static Properties createDeploymentProperties(Optional<Properties> deploymentProperties) {
        Properties properties;
        if (deploymentProperties.isPresent()) {
            properties = new Properties();
            properties.putAll((Map<?, ?>)deploymentProperties.get());
        } else {
            properties = new Properties();
        }
        properties.setProperty("mule.application.deployment.muteLog", "true");
        return properties;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.toolingServiceAppsFolder = this.createToolingServiceAppsFolder();
        this.artifactFileWriter = new ArtifactFileWriter(this.toolingServiceAppsFolder);
    }

    private File createToolingServiceAppsFolder() throws InitialisationException {
        File toolingServiceAppsFolder = new File(new File(MuleFoldersUtil.getMuleBaseFolder(), MULE_TMP_FILENAME), "tooling");
        if (!toolingServiceAppsFolder.exists()) {
            boolean folderCreated = toolingServiceAppsFolder.mkdirs();
            if (!folderCreated) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage("Couldn't start up the service"), (Throwable)new IOException("Couldn't create tooling service resources folder: " + toolingServiceAppsFolder), this);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create tooling service resources folder at: " + toolingServiceAppsFolder);
            }
        } else {
            try {
                FileUtils.cleanDirectory(toolingServiceAppsFolder);
            }
            catch (IOException e) {
                this.logger.warn("Could not clean up tooling service resources folder at: " + toolingServiceAppsFolder);
            }
        }
        return toolingServiceAppsFolder;
    }

    @Override
    public void stop() throws MuleException {
        if (this.toolingServiceAppsFolder != null) {
            try {
                FileUtils.cleanDirectory(this.toolingServiceAppsFolder);
            }
            catch (Exception e) {
                this.logger.warn("Couldn't clean up tooling service resources folder located at: " + this.toolingServiceAppsFolder);
            }
        }
    }

    public String getUniqueIdString(String type) {
        return "tooling-" + type + "-" + UUID.getUUID();
    }

    public static class DomainMavenReactorResolver
    implements MavenReactorResolver {
        private File domainArtifactLocation;
        private File domainPomFile;
        private org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor domainBundleDescriptor;

        public DomainMavenReactorResolver(File domainArtifactLocation, org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor domainBundleDescriptor) {
            this.domainArtifactLocation = domainArtifactLocation;
            this.domainBundleDescriptor = domainBundleDescriptor;
            this.domainPomFile = MavenUtils.lookupPomFromMavenLocation(this.domainArtifactLocation);
        }

        @Override
        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals("pom")) {
                    return this.domainPomFile;
                }
                return this.domainArtifactLocation;
            }
            return null;
        }

        @Override
        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.domainBundleDescriptor.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return this.domainBundleDescriptor.getGroupId().equals(bundleDescriptor.getGroupId()) && this.domainBundleDescriptor.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.domainBundleDescriptor.getVersion().equals(bundleDescriptor.getVersion());
        }
    }

    private class ToolingDomainWrapper
    extends DeployableArtifactWrapper<Domain, DomainDescriptor>
    implements Domain {
        protected ToolingDomainWrapper(Domain delegate) throws IOException {
            super(delegate);
        }

        @Override
        public boolean containsSharedResources() {
            return ((Domain)this.getDelegate()).containsSharedResources();
        }

        @Override
        public void dispose() {
            File domainLocation = this.getLocation();
            try {
                super.dispose();
            }
            catch (Throwable t) {
                DefaultToolingService.this.logger.warn(String.format("Error while disposing domain: {} ", super.getArtifactName()), t);
            }
            org.apache.commons.io.FileUtils.deleteQuietly((File)domainLocation);
        }
    }

    private class ToolingApplicationWrapper
    extends ApplicationWrapper {
        protected ToolingApplicationWrapper(Application delegate) throws IOException {
            super(delegate);
        }

        @Override
        public void dispose() {
            File appLocation = this.getLocation();
            try {
                super.dispose();
            }
            catch (Throwable t) {
                DefaultToolingService.this.logger.warn(String.format("Error while disposing application: {} ", this.getArtifactName()), t);
            }
            org.apache.commons.io.FileUtils.deleteQuietly((File)appLocation);
        }
    }
}

