/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.MethodRequestMatcher;

public class DefaultMethodRequestMatcher
implements MethodRequestMatcher {
    private final List<String> methods;

    public DefaultMethodRequestMatcher(HttpConstants.Method ... methods) {
        Preconditions.checkArgument(methods != null, "methods attribute should not be null");
        Preconditions.checkArgument(methods.length > 0, "methods attribute should not be empty");
        this.methods = Arrays.asList(methods).stream().map(m -> m.name().toUpperCase()).collect(Collectors.toList());
    }

    public DefaultMethodRequestMatcher(String ... methods) {
        Preconditions.checkArgument(methods != null, "methods attribute should not be null");
        Preconditions.checkArgument(methods.length > 0, "methods attribute should not be empty");
        this.methods = Arrays.asList(methods);
    }

    @Override
    public boolean intersectsWith(MethodRequestMatcher matcher) {
        Preconditions.checkArgument(matcher != null, "matcher cannot be null");
        for (String method : this.methods) {
            if (!matcher.getMethods().contains(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        return this.methods.contains(httpRequest.getMethod().toUpperCase());
    }

    public String toString() {
        return "MethodRequestMatcher{methods=" + DefaultMethodRequestMatcher.getMethodsListRepresentation(this.methods) + '}';
    }

    @Override
    public List<String> getMethods() {
        return ImmutableList.copyOf(this.methods);
    }

    public static String getMethodsListRepresentation(List<String> methods) {
        return methods.isEmpty() ? "*" : Arrays.toString(methods.toArray());
    }

    public int hashCode() {
        return 31 * this.methods.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultMethodRequestMatcher && Objects.equals(this.methods, ((DefaultMethodRequestMatcher)obj).methods);
    }
}

