/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzScheduledFututre<V>
implements ScheduledFuture<V> {
    private Scheduler quartzScheduler;
    private Trigger trigger;
    private RunnableFuture<?> task;

    QuartzScheduledFututre(Scheduler quartzScheduler, Trigger trigger, RunnableFuture<?> task) {
        this.quartzScheduler = quartzScheduler;
        this.trigger = trigger;
        this.task = task;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert((long)this.trigger.getNextFireTime().toInstant().getNano() - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean quartzCancelled;
        try {
            quartzCancelled = this.quartzScheduler.unscheduleJob(this.trigger.getKey());
        }
        catch (SchedulerException e) {
            throw new MuleRuntimeException(e);
        }
        boolean taskCancelled = this.task.cancel(mayInterruptIfRunning);
        return quartzCancelled || taskCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.task.isCancelled() || this.task.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }
}

