/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.ComponentModelInitializer;
import org.mule.runtime.config.internal.LazyComponentInitializerAdapter;
import org.mule.runtime.config.internal.LazyConnectivityTestingService;
import org.mule.runtime.config.internal.LazyMetadataService;
import org.mule.runtime.config.internal.LazyValueProviderService;
import org.mule.runtime.config.internal.MuleArtifactContext;
import org.mule.runtime.config.internal.OptionalObjectsController;
import org.mule.runtime.config.internal.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.TrackingPostProcessor;
import org.mule.runtime.config.internal.dsl.model.ConfigurationDependencyResolver;
import org.mule.runtime.config.internal.dsl.model.MinimalApplicationModelGenerator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigResource;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class LazyMuleArtifactContext
extends MuleArtifactContext
implements LazyComponentInitializerAdapter,
ComponentModelInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LazyMuleArtifactContext.class);
    private TrackingPostProcessor trackingPostProcessor = new TrackingPostProcessor();
    private Optional<ComponentModelInitializer> parentComponentModelInitializer;

    public LazyMuleArtifactContext(MuleContext muleContext, ConfigResource[] artifactConfigResources, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Map<String, String> artifactProperties, ArtifactType artifactType, List<ClassLoader> pluginsClassLoaders, Optional<ComponentModelInitializer> parentComponentModelInitializer, Optional<ConfigurationProperties> parentConfigurationProperties, boolean disableXmlValidations) throws BeansException {
        super(muleContext, artifactConfigResources, artifactDeclaration, optionalObjectsController, LazyMuleArtifactContext.extendArtifactProperties(artifactProperties), artifactType, pluginsClassLoaders, parentConfigurationProperties, disableXmlValidations);
        this.componentLocator = new SpringConfigurationComponentLocator();
        this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
        this.parentComponentModelInitializer = parentComponentModelInitializer;
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleConnectivityTestingService", new LazyConnectivityTestingService(this, () -> (ConnectivityTestingService)this.getRegistry().lookupByName("_muleNonLazyConnectivityTestingService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleMetadataService", new LazyMetadataService(this, () -> (MetadataService)this.getRegistry().lookupByName("_muleNonLazyMetadataService").get()));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleValueProviderService", new LazyValueProviderService(this, () -> (ValueProviderService)this.getRegistry().lookupByName("_muleNonLazyValueProviderService").get(), muleContext::getConfigurationComponentLocator));
        muleContext.getCustomizationService().registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class);
        muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleLazyComponentInitializer", this);
    }

    private static Map<String, String> extendArtifactProperties(Map<String, String> artifactProperties) {
        HashMap<String, String> extendedArtifactProperties = new HashMap<String, String>(artifactProperties);
        extendedArtifactProperties.put("mule.application.deployment.lazyInit", "true");
        return extendedArtifactProperties;
    }

    @Override
    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        this.trackingPostProcessor = new TrackingPostProcessor();
        this.addBeanPostProcessors(beanFactory, this.trackingPostProcessor);
    }

    private void applyLifecycle(List<String> createdComponentModels, boolean applyStartPhase) {
        this.muleContext.withLifecycleLock(() -> {
            Object object;
            if (this.muleContext.isInitialised()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.getRegistry().lookupByName(createdComponentModelName).get();
                    try {
                        this.muleContext.getRegistry().applyLifecycle(object, "initialise");
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (applyStartPhase && this.muleContext.isStarted()) {
                for (String createdComponentModelName : createdComponentModels) {
                    object = this.getRegistry().lookupByName(createdComponentModelName).get();
                    try {
                        this.muleContext.getRegistry().applyLifecycle(object, "initialise", "start");
                    }
                    catch (MuleException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    @Override
    public void initializeComponent(Location location) {
        this.initializeComponent(location, true);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter) {
        this.initializeComponents(filter, true);
    }

    @Override
    public void initializeComponent(Location location, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.empty(), Optional.of(location), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(LazyComponentInitializer.ComponentLocationFilter filter, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(o -> {
            ComponentModel componentModel = (ComponentModel)o;
            if (componentModel.getComponentLocation() != null) {
                return filter.accept(componentModel.getComponentLocation());
            }
            return false;
        }), Optional.empty(), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    @Override
    public void initializeComponents(Predicate<ComponentModel> componentModelPredicate, boolean applyStartPhase) {
        this.applyLifecycle(this.createComponents(Optional.of(componentModelPredicate), Optional.empty(), this.getParentComponentModelInitializerAdapter(applyStartPhase)), applyStartPhase);
    }

    public Optional<ComponentModelInitializerAdapter> getParentComponentModelInitializerAdapter(boolean applyStartPhase) {
        return this.parentComponentModelInitializer.map(componentModelInitializer -> componentModelPredicate1 -> componentModelInitializer.initializeComponents(componentModelPredicate1, applyStartPhase));
    }

    private List<String> createComponents(Optional<Predicate> predicateOptional, Optional<Location> locationOptional, Optional<ComponentModelInitializerAdapter> parentComponentModelInitializerAdapter) {
        Preconditions.checkState(predicateOptional.isPresent() != locationOptional.isPresent(), "predicate or location has to be passed");
        ArrayList<String> alreadyCreatedApplicationComponents = new ArrayList<String>();
        alreadyCreatedApplicationComponents.addAll(this.trackingPostProcessor.getBeansTracked());
        Collections.reverse(alreadyCreatedApplicationComponents);
        this.trackingPostProcessor.startTracking();
        Reference createdComponents = new Reference();
        ClassUtils.withContextClassLoader(this.muleContext.getExecutionClassLoader(), () -> {
            this.applicationModel.executeOnEveryMuleComponentTree(componentModel -> componentModel.setEnabled(false));
            ConfigurationDependencyResolver dependencyResolver = new ConfigurationDependencyResolver(this.applicationModel, this.componentBuildingDefinitionRegistry);
            MinimalApplicationModelGenerator minimalApplicationModelGenerator = new MinimalApplicationModelGenerator(dependencyResolver);
            Reference minimalApplicationModel = new Reference();
            predicateOptional.ifPresent(predicate -> minimalApplicationModel.set(minimalApplicationModelGenerator.getMinimalModel((Predicate<ComponentModel>)predicate)));
            locationOptional.ifPresent(location -> minimalApplicationModel.set(minimalApplicationModelGenerator.getMinimalModel((Location)location)));
            this.unregisterBeans(alreadyCreatedApplicationComponents);
            this.objectProviders.clear();
            if (parentComponentModelInitializerAdapter.isPresent()) {
                List missingComponentNames = dependencyResolver.getMissingDependencies().stream().filter(dependencyNode -> dependencyNode.isTopLevel()).map(dependencyNode -> dependencyNode.getComponentName()).collect(Collectors.toList());
                ((ComponentModelInitializerAdapter)parentComponentModelInitializerAdapter.get()).initializeComponents((ComponentModel componentModel) -> {
                    if (componentModel.getNameAttribute() != null) {
                        return missingComponentNames.contains(componentModel.getNameAttribute());
                    }
                    return false;
                });
            } else {
                dependencyResolver.getMissingDependencies().stream().forEach(globalElementName -> {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("Ignoring dependency %s because it does not exists", globalElementName));
                    }
                });
            }
            List<String> applicationComponents = this.createApplicationComponents((DefaultListableBeanFactory)this.getBeanFactory(), (ApplicationModel)minimalApplicationModel.get(), false);
            createdComponents.set(applicationComponents);
            super.prepareObjectProviders();
            applicationComponents.forEach(component -> this.getRegistry().lookupByName((String)component).get());
        });
        this.trackingPostProcessor.stopTracking();
        List createdComponentNames = (List)createdComponents.get();
        this.trackingPostProcessor.intersection(createdComponentNames);
        return createdComponentNames;
    }

    @Override
    protected void prepareObjectProviders() {
    }

    private void unregisterBeans(List<String> beanNames) {
        if (this.muleContext.isStarted()) {
            beanNames.forEach(beanName -> {
                block2: {
                    try {
                        LegacyRegistryUtils.unregisterObject(this.muleContext, beanName);
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)String.format("Exception unregistering an object during lazy initialization of component %s, exception message is %s", beanName, e.getMessage()));
                        if (!this.logger.isDebugEnabled()) break block2;
                        this.logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        this.removeFromComponentLocator(beanNames);
    }

    private void removeFromComponentLocator(List<String> locations) {
        locations.forEach(location -> this.componentLocator.removeComponent(Location.builderFromStringRepresentation(location).build()));
    }

    @FunctionalInterface
    private static interface ComponentModelInitializerAdapter {
        public void initializeComponents(Predicate<ComponentModel> var1);
    }
}

