/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.AbstractStreamProcessingStrategyFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class WorkQueueStreamProcessingStrategyFactory
extends AbstractStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return new WorkQueueStreamProcessingStrategy(this.getRingBufferSchedulerSupplier(muleContext, schedulersNamePrefix), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), this.getMaxConcurrency());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return WorkQueueStreamProcessingStrategy.class;
    }

    static class WorkQueueStreamProcessingStrategy
    extends AbstractStreamProcessingStrategyFactory.AbstractStreamProcessingStrategy
    implements Startable,
    Stoppable {
        private final Supplier<Scheduler> blockingSchedulerSupplier;
        private Scheduler blockingScheduler;
        private List<Sink> sinkList = new ArrayList<Sink>();

        protected WorkQueueStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscribers, String waitStrategy, Supplier<Scheduler> blockingSchedulerSupplier, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscribers, waitStrategy, maxConcurrency);
            this.blockingSchedulerSupplier = Objects.requireNonNull(blockingSchedulerSupplier);
        }

        @Override
        public ReactiveProcessor onPipeline(ReactiveProcessor pipeline) {
            if (this.maxConcurrency > this.subscribers) {
                return publisher -> Flux.from(publisher).flatMap(event -> Flux.just(event).transform(pipeline).subscribeOn(Schedulers.fromExecutorService(this.decorateScheduler(this.blockingScheduler))).subscriberContext(ctx -> ctx.put("mule.nb.processorScheduler", this.blockingScheduler)), this.maxConcurrency);
            }
            return super.onPipeline(pipeline);
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC) {
                return publisher -> Flux.from(publisher).transform(processor).publishOn(Schedulers.fromExecutorService(this.decorateScheduler(this.blockingScheduler)));
            }
            return super.onProcessor(processor);
        }

        @Override
        public void start() throws MuleException {
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            this.sinkList.stream().filter(sink -> sink instanceof Disposable).forEach(sink -> ((Disposable)((Object)sink)).dispose());
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
        }
    }
}

