/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class ForbiddenConfigurationPropertiesValidator
implements ExtensionModelValidator {
    public static final String CONFIGURATION_PROPERTY_NOT_SUPPORTED_FORMAT_MESSAGE = "Configuration properties is not supported, either use <mule:global-property ../>, ${file::file.txt} or <module:property/> instead. Offending global element '%s'";

    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                model.getModelProperty(GlobalElementComponentModelModelProperty.class).ifPresent(modelProperty -> {
                    Set<ComponentIdentifier> configurationPropertiesCollection = this.getConfigurationPropertiesIdentifiers();
                    modelProperty.getGlobalElements().forEach(globalElementComponentModel -> {
                        if (configurationPropertiesCollection.contains(globalElementComponentModel.getIdentifier())) {
                            problemsReporter.addError(new Problem(model, String.format(ForbiddenConfigurationPropertiesValidator.CONFIGURATION_PROPERTY_NOT_SUPPORTED_FORMAT_MESSAGE, globalElementComponentModel.getIdentifier())));
                        }
                    });
                });
            }

            private Set<ComponentIdentifier> getConfigurationPropertiesIdentifiers() {
                ServiceLoader<ConfigurationPropertiesProviderFactory> providerFactories = ServiceLoader.load(ConfigurationPropertiesProviderFactory.class);
                return StreamSupport.stream(providerFactories.spliterator(), false).map(ConfigurationPropertiesProviderFactory::getSupportedComponentIdentifier).collect(Collectors.toSet());
            }
        }.walk(extensionModel);
    }
}

