/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.internal.resources.manifest.ClassPackageFinder;

public class DefaultClassPackageFinder
implements ClassPackageFinder {
    private List<ClassPackageFinder> classFinders = new ArrayList<ClassPackageFinder>();

    public DefaultClassPackageFinder() {
        this.classFinders.add(this::usingClassloader);
    }

    public DefaultClassPackageFinder(ProcessingEnvironment processingEnvironment) {
        this();
        if (processingEnvironment != null) {
            this.classFinders.add(className -> this.usingProcessingEnvironment(className, processingEnvironment));
        }
    }

    @Override
    public Optional<String> packageFor(String className) {
        return this.classFinders.stream().map(finder -> finder.packageFor(className)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Optional<String> usingProcessingEnvironment(String className, ProcessingEnvironment processingEnvironment) {
        Element enclosingElement;
        TypeElement typeElement;
        if (processingEnvironment != null && (typeElement = processingEnvironment.getElementUtils().getTypeElement(className)) != null && (enclosingElement = typeElement.getEnclosingElement()).getKind().equals((Object)ElementKind.PACKAGE)) {
            return Optional.of(((PackageElement)enclosingElement).getQualifiedName().toString());
        }
        return Optional.empty();
    }

    private Optional<String> usingClassloader(String className) {
        try {
            Class aClass = ClassUtils.loadClass(className, Thread.currentThread().getContextClassLoader());
            return Optional.ofNullable(aClass.getPackage().getName());
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

