/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private boolean returnsListOfMessages = false;
    private final CursorProviderFactory cursorProviderFactory;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)((Object)componentModel);
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection(outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.muleContext = muleContext;
        this.cursorProviderFactory = cursorProviderFactory;
        this.defaultMediaType = componentModel.getModelProperty(MediaTypeModelProperty.class).map(MediaTypeModelProperty::getMediaType).orElseGet(() -> {
            if (componentModel instanceof HasOutputModel) {
                MetadataType output = ((HasOutputModel)((Object)componentModel)).getOutput().getType();
                return MetadataFormat.JAVA.equals(output.getMetadataFormat()) && output instanceof ObjectType ? MediaType.APPLICATION_JAVA : MediaType.ANY;
            }
            return MediaType.ANY;
        });
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        MediaType mediaType = this.resolveMediaType(value, operationContext);
        CoreEvent event = operationContext.getEvent();
        if (value instanceof Result) {
            Result resultValue = (Result)((Object)value);
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage((Result)((Object)value), mediaType, this.cursorProviderFactory, event, this.returnHandler.getDataType()) : MessageUtils.toMessage((Result)((Object)value), mediaType, this.cursorProviderFactory, event);
        }
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = MessageUtils.toMessageCollection((Collection)((Object)value), this.cursorProviderFactory, event);
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            value = MessageUtils.toMessageIterator((Iterator<Result>)value, this.cursorProviderFactory, event);
        }
        value = this.streamingContent(value, operationContext, this.cursorProviderFactory, event);
        Message.Builder messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)((Object)value), Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    private Object streamingContent(Object value, ExecutionContextAdapter operationContext, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        ConnectionHandler connectionHandler;
        if (value instanceof InputStream && (connectionHandler = (ConnectionHandler)operationContext.getVariable("MULE_CONNECTION_PARAM")) != null && StreamingUtils.supportsStreaming(operationContext.getComponentModel())) {
            value = new ConnectedInputStreamWrapper((InputStream)value, connectionHandler);
        }
        return StreamingUtils.streamingContent(value, cursorProviderFactory, event);
    }

    protected MediaType resolveMediaType(Object value, ExecutionContextAdapter<ComponentModel> operationContext) {
        Optional<MediaType> optionalMediaType;
        Charset existingEncoding = SystemUtils.getDefaultEncoding(this.muleContext);
        MediaType mediaType = this.defaultMediaType;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = mediaType.getCharset().get();
        }
        if (mediaType == null) {
            mediaType = MediaType.ANY;
        }
        if (operationContext.hasParameter("outputMimeType")) {
            mediaType = MediaType.parse((String)operationContext.getParameter("outputMimeType"));
        }
        mediaType = operationContext.hasParameter("outputEncoding") ? mediaType.withCharset(MediaTypeUtils.parseCharset((String)operationContext.getParameter("outputEncoding"))) : mediaType.withCharset(existingEncoding);
        return mediaType;
    }

    private class ConnectedInputStreamWrapper
    extends InputStream {
        private final InputStream delegate;
        private final ConnectionHandler<?> connectionHandler;

        private ConnectedInputStreamWrapper(InputStream delegate, ConnectionHandler<?> connectionHandler) {
            this.delegate = delegate;
            this.connectionHandler = connectionHandler;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                this.connectionHandler.release();
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

