/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;

public class LibFolderClassLoaderModelLoader
implements ClassLoaderModelLoader {
    static final String LIB_FOLDER = "lib";
    private static final Set<ArtifactType> supportedTypes = new HashSet<ArtifactType>(Arrays.asList(ArtifactType.SERVICE, ArtifactType.SERVER_PLUGIN));
    private static final String LIB_DIR = "lib";
    private static final String JAR_FILE = "*.jar";

    @Override
    public String getId() {
        return "service";
    }

    @Override
    public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (artifactFile == null || !artifactFile.exists()) {
            throw new IllegalArgumentException("Service folder does not exists: " + (artifactFile != null ? artifactFile.getName() : null));
        }
        ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder = new ClassLoaderModel.ClassLoaderModelBuilder();
        classLoaderModelBuilder.containing(this.getUrl(artifactFile));
        for (URL url : this.getServiceUrls(artifactFile)) {
            classLoaderModelBuilder.containing(url);
        }
        return classLoaderModelBuilder.build();
    }

    private URL getUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the service: [%s]", file.getAbsolutePath()), e);
        }
    }

    private List<URL> getServiceUrls(File rootFolder) {
        LinkedList<URL> urls = new LinkedList<URL>();
        this.addDirectoryToClassLoader(urls, rootFolder);
        this.loadJarsFromFolder(urls, new File(rootFolder, "lib"));
        return urls;
    }

    private void loadJarsFromFolder(List<URL> urls, File folder) {
        File[] files;
        if (!folder.exists()) {
            return;
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter(JAR_FILE);
        for (File jarFile : files = folder.listFiles((FilenameFilter)fileFilter)) {
            urls.add(this.getFileUrl(jarFile));
        }
    }

    private URL getFileUrl(File jarFile) {
        try {
            return jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Cannot create service class loader", e);
        }
    }

    private void addDirectoryToClassLoader(List<URL> urls, File classesFolder) {
        if (classesFolder.exists()) {
            urls.add(this.getFileUrl(classesFolder));
        }
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        return supportedTypes.contains((Object)artifactType);
    }
}

