/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.reader.parser;

import java.io.Serializable;
import org.mule.weave.v2.exception.IndexOutOfBoundsException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.csv.reader.parser.CSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.CSVParser;
import org.mule.weave.v2.module.csv.reader.parser.CSVRecord;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettings;
import org.mule.weave.v2.module.csv.reader.parser.CsvEntryToken$;
import org.mule.weave.v2.module.csv.reader.parser.CsvTokenHelper$;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVEntry;
import org.mule.weave.v2.module.csv.reader.parser.IndexedCSVRecordLocation;
import org.mule.weave.v2.module.reader.DefaultLongArray;
import org.mule.weave.v2.module.reader.DefaultLongArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import org.mule.weave.v2.module.xml.reader.TokenArray;
import org.mule.weave.v2.module.xml.reader.TokenArray$;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0001M\u0011\u0001#\u00138eKb,GmQ*W!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011A\u00029beN,'O\u0003\u0002\u0006\r\u00051!/Z1eKJT!a\u0002\u0005\u0002\u0007\r\u001chO\u0003\u0002\n\u0015\u00051Qn\u001c3vY\u0016T!a\u0003\u0007\u0002\u0005Y\u0014$BA\u0007\u000f\u0003\u00159X-\u0019<f\u0015\ty\u0001#\u0001\u0003nk2,'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%\u00195K\u0016)beN,'\u000f\u0003\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u001b\u00035\u0019wN\u001c;f]R\u0014V-\u00193feV\t1\u0004\u0005\u0002\u001d=5\tQD\u0003\u0002\u0006\u0011%\u0011q$\b\u0002\r'>,(oY3SK\u0006$WM\u001d\u0005\tC\u0001\u0011\t\u0011)A\u00057\u0005q1m\u001c8uK:$(+Z1eKJ\u0004\u0003\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013(\u0003-\u00197KV*fiRLgnZ:\u0011\u0005U)\u0013B\u0001\u0014\u0003\u0005-\u00195KV*fiRLgnZ:\n\u0005!2\u0012aC2tmN+G\u000f^5oOND\u0001B\u000b\u0001\u0003\u0002\u0003\u0006YaK\u0001\u0004GRD\bC\u0001\u00170\u001b\u0005i#B\u0001\u0018\u000b\u0003\u0015iw\u000eZ3m\u0013\t\u0001TFA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQA\r\u0001\u0005\u0002M\na\u0001P5oSRtDc\u0001\u001b8qQ\u0011QG\u000e\t\u0003+\u0001AQAK\u0019A\u0004-BQ!G\u0019A\u0002mAQaI\u0019A\u0002\u0011BqA\u000f\u0001C\u0002\u0013\u00051(\u0001\u0007sK\u000e|'\u000f\u001a+pW\u0016t7/F\u0001=!\taR(\u0003\u0002?;\t\u0001B)\u001a4bk2$Hj\u001c8h\u0003J\u0014\u0018-\u001f\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001f\u0002\u001bI,7m\u001c:e)>\\WM\\:!\u0011\u001d\u0011\u0005A1A\u0005\u0002\r\u000b!bY:w\u000b:$(/[3t+\u0005!\u0005CA#J\u001b\u00051%BA\u0003H\u0015\tA\u0005\"A\u0002y[2L!A\u0013$\u0003\u0015Q{7.\u001a8BeJ\f\u0017\u0010\u0003\u0004M\u0001\u0001\u0006I\u0001R\u0001\fGN4XI\u001c;sS\u0016\u001c\b\u0005C\u0004O\u0001\u0001\u0007I\u0011A(\u0002\u00111|7-\u0019;j_:,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\u0005\u0019>tw\rC\u0004X\u0001\u0001\u0007I\u0011\u0001-\u0002\u00191|7-\u0019;j_:|F%Z9\u0015\u0005ec\u0006CA)[\u0013\tY&K\u0001\u0003V]&$\bbB/W\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\n\u0004BB0\u0001A\u0003&\u0001+A\u0005m_\u000e\fG/[8oA!)\u0011\r\u0001C\u0001E\u0006A1m\u001c8uC&t7\u000f\u0006\u0002dMB\u0011\u0011\u000bZ\u0005\u0003KJ\u0013qAQ8pY\u0016\fg\u000eC\u0003hA\u0002\u0007\u0001.A\u0003j]\u0012,\u0007\u0010\u0005\u0002RS&\u0011!N\u0015\u0002\u0004\u0013:$\b\"\u00027\u0001\t\u0003i\u0017aA4fiR\u0011a.\u001d\t\u0003+=L!\u0001\u001d\u0002\u0003\u0013\r\u001bfKU3d_J$\u0007\"B4l\u0001\u0004A\u0007\"B:\u0001\t\u0003!\u0018\u0001C:lSBd\u0015N\\3\u0015\u0003eCQA\u001e\u0001\u0005\n]\f\u0011\"\u001a7f[\u0016tG/\u0011;\u0015\u0007a\f)\u0002E\u0002RsnL!A\u001f*\u0003\r=\u0003H/[8o!\u0015a\u0018\u0011BA\b\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005!#\u0001\u0004=e>|GOP\u0005\u0002'&\u0019\u0011q\u0001*\u0002\u000fA\f7m[1hK&!\u00111BA\u0007\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000f\u0011\u0006cA\u000b\u0002\u0012%\u0019\u00111\u0003\u0002\u0003\u001f%sG-\u001a=fI\u000e\u001bf+\u00128uefDQaZ;A\u0002!Dq!!\u0007\u0001\t\u0013\tY\"A\u0005qCJ\u001cXMT3yiR\t\u0001\u0010C\u0004\u0002 \u0001!\t!!\t\u0002+A\u0014xnY3tg:{g.U;pi\u0016$WI\u001c;ssR\u0011\u00111\u0005\t\u0007#\u0006\u0015\u0012qB2\n\u0007\u0005\u001d\"K\u0001\u0004UkBdWM\r\u0005\b\u0003W\u0001A\u0011AA\u0011\u0003I\u0001(o\\2fgN\fVo\u001c;fI\u0016sGO]=\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005a\u0011n]#oI>3WI\u001c;ssR\u00191-a\r\t\u0011\u0005U\u0012Q\u0006a\u0001\u0003o\t\u0011a\u0019\t\u0004#\u0006e\u0012bAA\u001e%\n!1\t[1s\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\nacY8ogVlW-\u00168uS2,e\u000eZ(g\u000b:$(/\u001f\u000b\u0002G\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013\u0001\u00067pO&;gn\u001c:j]\u001e\u001c\u0005.\u0019:t/\u0006\u0014h\u000eF\u0002Z\u0003\u0013B\u0001\"a\u0013\u0002D\u0001\u0007\u0011QJ\u0001\ti>LuM\\8sKB!\u0011qJA,\u001d\u0011\t\t&a\u0015\u0011\u0005y\u0014\u0016bAA+%\u00061\u0001K]3eK\u001aLA!!\u0017\u0002\\\t11\u000b\u001e:j]\u001eT1!!\u0016S\u0011\u001d\ty\u0006\u0001C\u0001\u0003C\nAA]3bIR\u0011\u0011q\u0007\u0005\b\u0003K\u0002A\u0011AA4\u00031I7/\u00128e\u001f\u001aLe\u000e];u)\r\u0019\u0017\u0011\u000e\u0005\t\u0003W\n\u0019\u00071\u0001\u00028\u0005!a.\u001a=u\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\n1b\u0019:fCR,WI\u001c;ssR1\u0011qBA:\u0003oBq!!\u001e\u0002n\u0001\u0007\u0001+\u0001\u0006wC2,X-\u00138eKbDq!!\u001f\u0002n\u0001\u00071-\u0001\u0005jgF+x\u000e^3e\u0011\u001d\ty\u0007\u0001C\u0001\u0003{\"\u0002\"a\u0004\u0002\u0000\u0005\u0005\u0015Q\u0011\u0005\b\u0003k\nY\b1\u0001Q\u0011\u001d\t\u0019)a\u001fA\u0002A\u000bAa]5{K\"9\u0011\u0011PA>\u0001\u0004\u0019\u0007")
public class IndexedCSVParser
extends CSVParser {
    private final SourceReader contentReader;
    private final EvaluationContext ctx;
    private final DefaultLongArray recordTokens;
    private final TokenArray csvEntries;
    private long location;

    public SourceReader contentReader() {
        return this.contentReader;
    }

    public DefaultLongArray recordTokens() {
        return this.recordTokens;
    }

    public TokenArray csvEntries() {
        return this.csvEntries;
    }

    public long location() {
        return this.location;
    }

    public void location_$eq(long x$1) {
        this.location = x$1;
    }

    public boolean contains(int index) {
        return this.recordTokens().size() > (long)index ? true : this.elementAt(index).isDefined();
    }

    public CSVRecord get(int index) {
        Option<Seq<IndexedCSVEntry>> parsed = this.elementAt(index);
        if (!parsed.isDefined()) {
            throw new IndexOutOfBoundsException(UnknownLocation$.MODULE$, index, this.recordTokens().size());
        }
        return new CSVRecord((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.headers(), this.headersWithIndex(), new IndexedCSVRecordLocation((Seq<? extends CSVEntry>)((Seq)parsed.get()), this.contentReader()));
    }

    @Override
    public void skipLine() {
        this.contentReader().seek(this.location());
        char next = this.contentReader().lookAheadAscii();
        if (next != '\uffff') {
            char value = this.contentReader().readAscii();
            while (next != '\uffff' && value != '\n' && (value != '\r' || next == '\n')) {
                value = this.contentReader().readAscii();
                next = this.contentReader().lookAheadAscii();
                this.location_$eq(this.contentReader().position());
            }
        }
    }

    private Option<Seq<IndexedCSVEntry>> elementAt(int index) {
        None$ none$;
        long size;
        if (this.headers().isEmpty()) {
            Option<Seq<IndexedCSVEntry>> headerParsing;
            boolean hasHeaderLine;
            int headerLine = super.csvSettings().headerLineNumber();
            boolean bl = hasHeaderLine = headerLine > 0;
            if (hasHeaderLine) {
                this.skipLines(headerLine - 1);
            }
            if (super.csvSettings().header() && (headerParsing = this.parseNext()).isDefined()) {
                this.processHeaders((Seq<? extends CSVEntry>)((Seq)headerParsing.get()));
            }
            this.skipLines(this.linesToSkipBeforeBody());
        }
        if ((size = this.recordTokens().size()) <= (long)index) {
            for (long remaining = (long)index - size; remaining >= 0L; --remaining) {
                Option<Seq<IndexedCSVEntry>> nextRecordMaybe = this.parseNext();
                if (!nextRecordMaybe.isDefined()) continue;
                Seq nextRecord = (Seq)nextRecordMaybe.get();
                long recordOffset = this.csvEntries().length();
                int numOfColumns = nextRecord.length();
                long recordToken = CsvTokenHelper$.MODULE$.createRecordToken(recordOffset, numOfColumns);
                this.recordTokens().$plus$eq(recordToken);
                this.csvEntries().$plus$plus$eq((Seq<long[]>)((Seq)nextRecord.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.token(), Seq$.MODULE$.canBuildFrom())));
                if (remaining != 0L) continue;
                return new Some((Object)nextRecord);
            }
            none$ = None$.MODULE$;
        } else {
            long recordToken = this.recordTokens().apply(index);
            IndexedCSVEntry[] record = CsvTokenHelper$.MODULE$.getRecord(recordToken, this.csvEntries(), this.contentReader(), this.helper());
            none$ = new Some((Object)Predef$.MODULE$.wrapRefArray((Object[])record));
        }
        return none$;
    }

    private Option<Seq<IndexedCSVEntry>> parseNext() {
        None$ none$;
        block3: {
            block2: {
                ArrayBuffer recordEntries;
                do {
                    this.contentReader().seek(this.location());
                    recordEntries = new ArrayBuffer();
                    char value = this.contentReader().lookAheadAscii();
                    if (value == '\uffff') break block2;
                    boolean recordFinished = false;
                    while (!recordFinished) {
                        Tuple2<IndexedCSVEntry, Object> quotedEntry = this.processNonQuotedEntry();
                        recordEntries.$plus$eq(quotedEntry._1());
                        recordFinished = quotedEntry._2$mcZ$sp();
                    }
                    this.location_$eq(this.contentReader().position());
                } while (super.csvSettings().ignoreEmptyLine() && recordEntries.length() == 1 && ((IndexedCSVEntry)recordEntries.apply(0)).length() == 0L);
                none$ = new Some((Object)recordEntries);
                break block3;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processNonQuotedEntry() {
        void var1_1;
        Tuple2 result = null;
        boolean isBlank = true;
        long valueIndex = this.contentReader().position();
        boolean isQuoted = false;
        while (result == null) {
            Object object;
            char next = this.read();
            if (this.isQuoteChar(next) && isBlank) {
                result = this.processQuotedEntry();
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEscapeChar(next) && this.requiresEscape(this.contentReader().lookAheadAscii())) {
                char c = this.read();
                if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c))) {
                    isBlank = false;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isColumnSeparator(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isEndOfInput(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, this.contentReader().position() - valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                object = BoxedUnit.UNIT;
                continue;
            }
            if (this.isLineEnding(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                if (next == '\r' && this.contentReader().lookAheadAscii() == '\n') {
                    object = BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii());
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (!RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(next))) {
                isBlank = false;
            }
            object = BoxedUnit.UNIT;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<IndexedCSVEntry, Object> processQuotedEntry() {
        void var3_2;
        long valueIndex = this.contentReader().position();
        Tuple2 result = null;
        boolean isQuoted = true;
        while (result == null) {
            Character c;
            char next = this.read();
            long size = this.contentReader().previousPosition() - valueIndex;
            if (this.isEscapeChar(next) && this.isQuoteChar(this.contentReader().lookAheadAscii())) {
                c = BoxesRunTime.boxToCharacter((char)this.read());
                continue;
            }
            if (this.isQuoteChar(next)) {
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)this.consumeUntilEndOfEntry()));
            } else if (this.isEndOfInput(next)) {
                this.ctx.serviceManager().loggingService().logWarn("Quoted Entry was not closed and end of input was reached.");
                result = new Tuple2((Object)this.createEntry(valueIndex, size, isQuoted), (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            c = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    public boolean isEndOfEntry(char c) {
        return this.isColumnSeparator(c) || this.isLineEnding(c) || this.isEndOfInput(c);
    }

    public boolean consumeUntilEndOfEntry() {
        StringBuilder builder = new StringBuilder();
        char next = this.read();
        while (true) {
            builder.append(next);
            if (this.isColumnSeparator(next)) {
                this.logIgnoringCharsWarn(builder.toString());
                return false;
            }
            if (this.isEndOfInput(next)) {
                this.logIgnoringCharsWarn(builder.toString());
                return true;
            }
            if (this.isLineEnding(next)) {
                Object object = next == '\r' && this.contentReader().lookAheadAscii() == '\n' ? BoxesRunTime.boxToCharacter((char)this.contentReader().readAscii()) : BoxedUnit.UNIT;
                this.logIgnoringCharsWarn(builder.toString());
                return true;
            }
            next = this.read();
        }
    }

    public void logIgnoringCharsWarn(String toIgnore) {
        this.ctx.serviceManager().loggingService().logWarn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed CSV input. Ignoring following chars after quoted value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toIgnore})));
    }

    public char read() {
        return this.contentReader().read();
    }

    public boolean isEndOfInput(char next) {
        return next == '\uffff';
    }

    public IndexedCSVEntry createEntry(long valueIndex, boolean isQuoted) {
        return this.createEntry(valueIndex, this.contentReader().previousPosition() - valueIndex, isQuoted);
    }

    public IndexedCSVEntry createEntry(long valueIndex, long size, boolean isQuoted) {
        long[] token = CsvEntryToken$.MODULE$.apply(valueIndex, size, isQuoted);
        return new IndexedCSVEntry(token, this.contentReader(), this.helper());
    }

    public IndexedCSVParser(SourceReader contentReader, CSVSettings cSVSettings, EvaluationContext ctx) {
        this.contentReader = contentReader;
        this.ctx = ctx;
        super(cSVSettings);
        ctx.registerCloseable(contentReader);
        this.recordTokens = ctx.registerCloseable(new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1()));
        this.csvEntries = ctx.registerCloseable(new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1()));
        this.location = 0L;
    }
}

