/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import java.util.Set;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class EnumHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof EnumSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        EnumSchema enumSchema = (EnumSchema)schema;
        StringTypeBuilder enumMetadataBuilder = root.stringType();
        Set possibleValues = enumSchema.getPossibleValues();
        String[] stringValues = (String[])possibleValues.stream().map(v -> String.valueOf(v)).toArray(String[]::new);
        enumMetadataBuilder.enumOf(stringValues);
        return enumMetadataBuilder;
    }
}

