/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

abstract class AbstractEventContext
implements BaseEventContext {
    private static final int STATE_READY = 0;
    private static final int STATE_RESPONSE = 1;
    private static final int STATE_COMPLETE = 2;
    private static final int STATE_TERMINATED = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    private static final FlowExceptionHandler NULL_EXCEPTION_HANDLER = NullExceptionHandler.getInstance();
    private final transient List<BaseEventContext> childContexts = new ArrayList<BaseEventContext>();
    private final transient FlowExceptionHandler exceptionHandler;
    private final transient CompletableFuture<Void> externalCompletion;
    private final transient List<BiConsumer<CoreEvent, Throwable>> onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final transient List<BiConsumer<CoreEvent, Throwable>> onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final transient List<BiConsumer<CoreEvent, Throwable>> onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private ReadWriteLock childContextsReadWriteLock = new ReentrantReadWriteLock();
    private volatile int state = 0;
    private volatile Either<Throwable, CoreEvent> result;
    private final Set<ResponsePublisher> responsePublishers = new HashSet<ResponsePublisher>();
    protected FlowCallStack flowCallStack = new DefaultFlowCallStack();

    public AbstractEventContext() {
        this(NULL_EXCEPTION_HANDLER, Optional.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler) {
        this(exceptionHandler, Optional.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler, Optional<CompletableFuture<Void>> externalCompletion) {
        this.externalCompletion = externalCompletion.orElse(null);
        externalCompletion.ifPresent(completableFuture -> completableFuture.thenAccept(aVoid -> this.tryTerminate()));
        this.exceptionHandler = exceptionHandler;
    }

    void addChildContext(BaseEventContext childContext) {
        this.childContextsReadWriteLock.writeLock().lock();
        try {
            this.childContexts.add(childContext);
        }
        finally {
            this.childContextsReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public final void success() {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " empty response was already completed, ignoring.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " response completed with no result.");
        }
        this.responseDone(Either.right(null));
    }

    @Override
    public final void success(CoreEvent event) {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " response was already completed, ignoring.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " response completed with result.");
        }
        this.responseDone(Either.right(event));
    }

    @Override
    public final Publisher<Void> error(Throwable throwable) {
        if (this.isResponseDone()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " error response was already completed, ignoring.");
            }
            return Mono.empty();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this + " responseDone completed with error.");
        }
        if (throwable instanceof MessagingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " handling messaging exception.");
            }
            return Mono.just((MessagingException)throwable).flatMapMany(this.exceptionHandler).doOnNext(handled -> this.success((CoreEvent)handled)).doOnError(rethrown -> this.responseDone(Either.left(rethrown))).materialize().then().toProcessor();
        }
        this.responseDone(Either.left(throwable));
        return Mono.empty();
    }

    private synchronized void responseDone(Either<Throwable, CoreEvent> result) {
        this.result = result;
        this.responsePublishers.forEach(rp -> ((ResponsePublisher)rp).result = result);
        this.state = 1;
        this.onResponseConsumerList.stream().forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
        this.tryComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryComplete() {
        boolean allChildrenComplete;
        this.childContextsReadWriteLock.readLock().lock();
        try {
            allChildrenComplete = this.childContexts.stream().allMatch(context -> context.isComplete());
        }
        finally {
            this.childContextsReadWriteLock.readLock().unlock();
        }
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.state == 1 && allChildrenComplete) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this + " completed.");
                }
                this.state = 2;
                this.onCompletionConsumerList.forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
                this.getParentContext().ifPresent(context -> {
                    if (context instanceof AbstractEventContext) {
                        ((AbstractEventContext)context).tryComplete();
                    }
                });
                this.tryTerminate();
            }
        }
    }

    protected synchronized void tryTerminate() {
        if (this.state == 2 && (this.externalCompletion == null || this.externalCompletion.isDone())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this + " terminated.");
            }
            this.state = 3;
            this.onTerminatedConsumerList.forEach(consumer -> this.signalConsumerSilently((BiConsumer<CoreEvent, Throwable>)consumer));
            this.childContextsReadWriteLock.writeLock().lock();
            try {
                this.childContexts.clear();
            }
            finally {
                this.childContextsReadWriteLock.writeLock().unlock();
            }
            this.result = null;
            this.responsePublishers.clear();
        }
    }

    private void signalConsumerSilently(BiConsumer<CoreEvent, Throwable> consumer) {
        try {
            consumer.accept(this.result.getRight(), this.result.getLeft());
        }
        catch (Throwable t) {
            LOGGER.error(String.format("The event consumer %s, of EventContext %s failed with exception:", consumer.toString(), this.toString()), t);
        }
    }

    @Override
    public BaseEventContext getRootContext() {
        return this.getParentContext().map(BaseEventContext::getRootContext).orElse(this);
    }

    protected FlowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    private boolean isResponseDone() {
        return this.state >= 1;
    }

    @Override
    public boolean isComplete() {
        return this.state >= 2;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public synchronized void onTerminated(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 3) {
            this.signalConsumerSilently(consumer);
        }
        this.onTerminatedConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public synchronized void onComplete(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 2) {
            this.signalConsumerSilently(consumer);
        }
        this.onCompletionConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public synchronized void onResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 1) {
            this.signalConsumerSilently(consumer);
        }
        this.onResponseConsumerList.add(Objects.requireNonNull(consumer));
    }

    @Override
    public synchronized Publisher<CoreEvent> getResponsePublisher() {
        if (this.isTerminated()) {
            throw new IllegalStateException("getResponsePublisher() cannot be called after eventContext termination.");
        }
        ResponsePublisher responsePublisher = new ResponsePublisher();
        this.responsePublishers.add(responsePublisher);
        return Mono.create(responsePublisher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachChild(Consumer<BaseEventContext> childConsumer) {
        this.childContextsReadWriteLock.readLock().lock();
        try {
            for (BaseEventContext context : this.childContexts) {
                if (context.isTerminated()) continue;
                childConsumer.accept(context);
                if (!(context instanceof AbstractEventContext)) continue;
                ((AbstractEventContext)context).forEachChild(childConsumer);
            }
        }
        finally {
            this.childContextsReadWriteLock.readLock().unlock();
        }
    }

    private final class ResponsePublisher
    implements Consumer<MonoSink<CoreEvent>> {
        private volatile Either<Throwable, CoreEvent> result;

        private ResponsePublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(MonoSink<CoreEvent> sink) {
            if (AbstractEventContext.this.isResponseDone()) {
                this.signalPublisherSink(sink);
            } else {
                AbstractEventContext abstractEventContext = AbstractEventContext.this;
                synchronized (abstractEventContext) {
                    if (AbstractEventContext.this.isResponseDone()) {
                        this.signalPublisherSink(sink);
                    } else {
                        AbstractEventContext.this.onResponse((event, throwable) -> {
                            if (throwable != null) {
                                sink.error((Throwable)throwable);
                            } else {
                                sink.success((CoreEvent)event);
                            }
                        });
                    }
                }
            }
        }

        private void signalPublisherSink(MonoSink<CoreEvent> sink) {
            if (this.result.isLeft()) {
                sink.error(this.result.getLeft());
            } else {
                sink.success(this.result.getRight());
            }
        }
    }
}

