/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.mule.runtime.core.internal.policy.PolicyNotificationHelper;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PolicyNextActionMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyNextActionMessageProcessor.class);
    @Inject
    private PolicyStateHandler policyStateHandler;
    @Inject
    private MuleContext muleContext;
    private PolicyNotificationHelper notificationHelper;
    private PolicyEventConverter policyEventConverter = new PolicyEventConverter();

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    private Consumer<CoreEvent> pushAfterNextFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.toPolicyLocation(this.getLocation()), null));
    }

    private String toPolicyLocation(ComponentLocation componentLocation) {
        return componentLocation.getParts().get(0).getPartPath() + "/" + componentLocation.getParts().get(1).getPartPath() + "[after next]";
    }

    private Consumer<CoreEvent> popBeforeNextFlowFlowStackElement() {
        return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Mono.from(publisher).doOnNext(coreEvent -> this.logExecuteNextEvent("Before execute-next", coreEvent.getContext(), coreEvent.getMessage(), this.muleContext.getConfiguration().getId())).flatMap(event -> {
            Processor nextOperation = this.policyStateHandler.retrieveNextOperation(event.getContext().getCorrelationId());
            if (nextOperation == null) {
                return Mono.error(new MuleRuntimeException(I18nMessageFactory.createStaticMessage("There's no next operation configured for event context id " + event.getContext().getCorrelationId())));
            }
            this.popBeforeNextFlowFlowStackElement().accept((CoreEvent)event);
            this.notificationHelper.notification(2102).accept((CoreEvent)event);
            return Mono.from(MessageProcessors.processWithChildContext(event, (ReactiveProcessor)nextOperation, Optional.ofNullable(this.getLocation()))).doOnSuccessOrError(this.notificationHelper.successOrErrorNotification(2103).andThen((? super T ev, ? super U t) -> this.pushAfterNextFlowStackElement().accept((CoreEvent)event))).onErrorResume(MessagingException.class, t -> {
                PolicyStateId policyStateId = new PolicyStateId(event.getContext().getCorrelationId(), this.muleContext.getConfiguration().getId());
                this.policyStateHandler.getLatestState(policyStateId).ifPresent(latestStateEvent -> t.setProcessedEvent(this.policyEventConverter.createEvent((PrivilegedEvent)t.getEvent(), (PrivilegedEvent)latestStateEvent)));
                ((BaseEventContext)event.getContext()).error(this.resolveMessagingException(t.getFailingComponent(), this.muleContext).apply((MessagingException)t));
                return Mono.empty();
            }).doOnNext(coreEvent -> this.logExecuteNextEvent("After execute-next", coreEvent.getContext(), coreEvent.getMessage(), this.muleContext.getConfiguration().getId()));
        });
    }

    private Function<MessagingException, MessagingException> resolveMessagingException(Component processor, MuleContext muleContext) {
        if (processor != null) {
            MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
            return exception -> exceptionResolver.resolve((MessagingException)exception, muleContext);
        }
        return exception -> exception;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.notificationHelper = new PolicyNotificationHelper(this.muleContext.getNotificationManager(), this.muleContext.getConfiguration().getId(), this);
    }

    private void logExecuteNextEvent(String startingMessage, EventContext eventContext, Message message, String policyName) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("\nEvent Id: " + eventContext.getCorrelationId() + "\n" + startingMessage + ".\nPolicy: " + policyName + "\n" + message.getAttributes().getValue().toString());
        }
    }
}

