/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.component.ComponentUtils;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.processor.strategy.DirectProcessingStrategyFactory;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class AsyncDelegateMessageProcessor
extends AbstractMessageProcessorOwner
implements Scope,
Initialisable,
Startable,
Stoppable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean ownProcessingStrategy = false;
    private ProcessingStrategy processingStrategy;
    private Sink sink;
    private MessageProcessorChainBuilder delegateBuilder;
    protected MessageProcessorChain delegate;
    private org.mule.runtime.api.scheduler.Scheduler scheduler;
    private Scheduler reactorScheduler;
    protected String name;

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate) {
        this.delegateBuilder = delegate;
    }

    public AsyncDelegateMessageProcessor(MessageProcessorChainBuilder delegate, String name) {
        this.delegateBuilder = delegate;
        this.name = name;
    }

    @Override
    public void initialise() throws InitialisationException {
        Object rootContainer = ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).orElse(null);
        this.processingStrategy = rootContainer instanceof FlowConstruct ? ((FlowConstruct)rootContainer).getProcessingStrategy() : DirectProcessingStrategyFactory.DIRECT_PROCESSING_STRATEGY_INSTANCE;
        if (this.delegateBuilder == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("delegate message processor"), (Initialisable)this);
        }
        this.delegateBuilder.setProcessingStrategy(this.processingStrategy);
        this.delegate = this.delegateBuilder.build();
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
        super.initialise();
    }

    @Override
    public void start() throws MuleException {
        if (this.ownProcessingStrategy) {
            LifecycleUtils.startIfNeeded(this.processingStrategy);
        }
        this.sink = this.processingStrategy.createSink(ComponentUtils.getFromAnnotatedObject(this.componentLocator, this).filter(c -> c instanceof FlowConstruct).orElse(null), this.processAsyncChainFunction());
        if (this.processingStrategy.isSynchronous()) {
            this.scheduler = this.schedulerService.ioScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name != null ? this.name : this.getLocation().getLocation()));
            this.reactorScheduler = Schedulers.fromExecutorService(this.scheduler);
        }
        LifecycleUtils.startIfNeeded(this.delegate);
        super.start();
    }

    @Override
    public void stop() throws MuleException {
        super.stop();
        LifecycleUtils.stopIfNeeded(this.delegate);
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.processingStrategy.isSynchronous() && this.reactorScheduler != null) {
            this.reactorScheduler.dispose();
            this.reactorScheduler = null;
        }
        LifecycleUtils.disposeIfNeeded(this.sink, this.logger);
        this.sink = null;
        if (this.ownProcessingStrategy) {
            LifecycleUtils.stopIfNeeded(this.processingStrategy);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        LifecycleUtils.disposeIfNeeded(this.delegate, this.logger);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).cast(PrivilegedEvent.class).doOnNext(request -> Flux.just(request).map(event -> this.asyncEvent((PrivilegedEvent)event)).map(event -> {
            this.sink.accept((CoreEvent)event);
            return event;
        }).subscribe(Operators.requestUnbounded())).cast(CoreEvent.class);
    }

    private CoreEvent asyncEvent(PrivilegedEvent event) {
        return PrivilegedEvent.builder(DefaultEventContext.child(event.getContext(), Optional.ofNullable(this.getLocation())), event).replyToHandler(null).session(new DefaultMuleSession(event.getSession())).build();
    }

    private ReactiveProcessor processAsyncChainFunction() {
        return innerPublisher -> Flux.from(innerPublisher).doOnNext(this.fireAsyncScheduledNotification()).transform(this.scheduleAsync(this.delegate)).doOnNext(event -> {
            this.fireAsyncCompleteNotification((CoreEvent)event, null);
            ((BaseEventContext)event.getContext()).success((CoreEvent)event);
        }).doOnError(MessagingException.class, e -> {
            this.fireAsyncCompleteNotification(e.getEvent(), (MessagingException)e);
            ((BaseEventContext)e.getEvent().getContext()).error((Throwable)e);
        }).doOnError(throwable -> this.logger.warn("Error occurred during asynchronous processing at:" + this.getLocation().getLocation() + " . To handle this error include a <try> scope in the <async> scope.", throwable));
    }

    private ReactiveProcessor scheduleAsync(Processor delegate) {
        if (this.processingStrategy.isSynchronous()) {
            return publisher -> Flux.from(publisher).transform(delegate).subscribeOn(this.reactorScheduler);
        }
        return delegate;
    }

    private Consumer<CoreEvent> fireAsyncScheduledNotification() {
        return event -> this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(EnrichedNotificationInfo.createInfo(event, null, this), this.getLocation(), 1901));
    }

    private void fireAsyncCompleteNotification(CoreEvent event, MessagingException exception) {
        this.muleContext.getNotificationManager().fireNotification(new AsyncMessageNotification(EnrichedNotificationInfo.createInfo(event, exception, this), this.getLocation(), 1902));
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.delegate);
    }

    @Override
    protected List<Processor> getOwnedObjects() {
        return Collections.emptyList();
    }
}

