/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.ReferenceProcessor;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageProcessorChainBuilder.class);

    @Override
    public MessageProcessorChain build() {
        LinkedList<Processor> tempList = new LinkedList<Processor>();
        LinkedList<Processor> processorsForLifecycle = new LinkedList<Processor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            Processor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (processor instanceof InterceptingMessageProcessor && (!(processor instanceof ReferenceProcessor) || ((ReferenceProcessor)processor).getReferencedProcessor() instanceof InterceptingMessageProcessor)) {
                InterceptingMessageProcessor interceptingProcessor = (InterceptingMessageProcessor)processor;
                if (i + 1 < this.processors.size()) {
                    MessageProcessorChain innerChain = this.createSimpleChain(tempList, interceptingProcessor.isBlocking() ? Optional.of(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE) : Optional.ofNullable(this.processingStrategy));
                    processorsForLifecycle.addFirst(innerChain);
                    interceptingProcessor.setListener(innerChain);
                }
                tempList = new LinkedList<Processor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(processor);
        }
        Processor head = tempList.size() == 1 ? (Processor)tempList.get(0) : this.createSimpleChain(tempList, Optional.ofNullable(this.processingStrategy));
        processorsForLifecycle.addFirst(head);
        return this.createInterceptingChain(head, this.processors, processorsForLifecycle);
    }

    protected MessageProcessorChain createSimpleChain(List<Processor> tempList, Optional<ProcessingStrategy> processingStrategyOptional) {
        if (tempList.size() == 1 && tempList.get(0) instanceof SimpleMessageProcessorChain) {
            return (MessageProcessorChain)tempList.get(0);
        }
        return new SimpleMessageProcessorChain("(inner chain) of " + this.name, processingStrategyOptional, new ArrayList<Processor>(tempList));
    }

    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
        return new DefaultMessageProcessorChain("(outer intercepting chain) of " + this.name, Optional.ofNullable(this.processingStrategy), head, processors, processorsForLifecycle);
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(Processor ... processors) {
        for (Processor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<Processor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(Processor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    public static MessageProcessorChain newLazyProcessorChainBuilder(final AbstractMessageProcessorChainBuilder chainBuilder, MuleContext muleContext, final Supplier<ProcessingStrategy> processingStrategySupplier) {
        return new AbstractMessageProcessorChain(chainBuilder.name, Optional.empty(), chainBuilder.processors){
            private MessageProcessorChain delegate;

            @Override
            public void initialise() throws InitialisationException {
                chainBuilder.setProcessingStrategy((ProcessingStrategy)processingStrategySupplier.get());
                this.delegate = chainBuilder.build();
                this.delegate.setAnnotations(this.getAnnotations());
                LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
            }

            @Override
            public void start() throws MuleException {
                LifecycleUtils.startIfNeeded(this.delegate);
            }

            @Override
            public void dispose() {
                LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
            }

            @Override
            public void stop() throws MuleException {
                LifecycleUtils.stopIfNeeded(this.delegate);
            }

            @Override
            public CoreEvent process(CoreEvent event) throws MuleException {
                return this.delegate.process(event);
            }

            @Override
            public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
                return this.delegate.apply(publisher);
            }
        };
    }

    protected static class DefaultMessageProcessorChain
    extends AbstractMessageProcessorChain {
        private Processor head;
        private List<Processor> processorsForLifecycle;

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, processingStrategyOptional, processors);
            this.head = head;
            this.processorsForLifecycle = processorsForLifecycle;
        }

        @Override
        protected List<Processor> getMessageProcessorsForLifecycle() {
            return this.processorsForLifecycle;
        }

        @Override
        protected List<Processor> getProcessorsToExecute() {
            return Collections.singletonList(this.head);
        }
    }

    static class SimpleMessageProcessorChain
    extends AbstractMessageProcessorChain {
        SimpleMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors) {
            super(name, processingStrategyOptional, processors);
        }
    }
}

