/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T>,
Initialisable {
    private final MetadataType expectedMetadataType;
    private final Class<T> expectedType;
    private final String expression;
    private TypeSafeValueResolverWrapper<T> delegate;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExtendedExpressionManager extendedExpressionManager;
    @Inject
    private MuleContext muleContext;

    public TypeSafeExpressionValueResolver(String expression, Class<T> expectedType, MetadataType expectedMetadataType) {
        Preconditions.checkArgument(expectedType != null, "expected type cannot be null");
        this.expression = expression;
        this.expectedType = expectedType;
        this.expectedMetadataType = expectedMetadataType;
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        return this.delegate.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void initialise() throws InitialisationException {
        ExpressionValueResolver resolver = new ExpressionValueResolver(this.expression, IntrospectionUtils.toDataType(this.expectedMetadataType));
        resolver.setExtendedExpressionManager(this.extendedExpressionManager);
        this.delegate = new TypeSafeValueResolverWrapper<T>(resolver, this.expectedType);
        this.delegate.setTransformationService(this.transformationService);
        LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
    }

    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    public void setExtendedExpressionManager(ExtendedExpressionManager extendedExpressionManager) {
        this.extendedExpressionManager = extendedExpressionManager;
    }
}

