/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;
import org.mule.service.scheduler.internal.config.ContainerThreadPoolsConfig;
import org.mule.service.scheduler.internal.reporting.DefaultSchedulerView;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchedulerService
implements SchedulerService,
Startable,
Stoppable {
    private static final String USAGE_TRACE_INTERVAL_SECS_PROPERTY = "mule.scheduler.usageTraceIntervalSecs";
    public static final Long USAGE_TRACE_INTERVAL_SECS = Long.getLong("mule.scheduler.usageTraceIntervalSecs");
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulerService.class);
    public static final Logger traceLogger = LoggerFactory.getLogger((String)"org.mule.service.scheduler.trace");
    private static final long DEFAULT_SHUTDOWN_TIMEOUT_MILLIS = 5000L;
    private static final int CORES = Runtime.getRuntime().availableProcessors();
    private ReadWriteLock pollsLock = new ReentrantReadWriteLock();
    private Lock pollsReadLock = this.pollsLock.readLock();
    private Lock pollsWriteLock = this.pollsLock.writeLock();
    private ContainerThreadPoolsConfig containerThreadPoolsConfig;
    private LoadingCache<SchedulerPoolsConfigFactory, SchedulerThreadPools> poolsByConfig;
    private Scheduler poolsMaintenanceScheduler;
    private ScheduledFuture<?> poolsMaintenanceTask;
    private ScheduledFuture<?> usageReportingTask;
    private volatile boolean started = false;

    @Override
    public String getName() {
        return SchedulerService.class.getSimpleName();
    }

    @Override
    public Scheduler cpuLightScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler ioScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuIntensiveScheduler() {
        this.checkStarted();
        SchedulerConfig config = SchedulerConfig.config();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuLightScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler ioScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public Scheduler cpuIntensiveScheduler(SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    @Inject
    public Scheduler cpuLightScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuLightScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    @Inject
    public Scheduler ioScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createIoScheduler(config, this.ioBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    @Inject
    public Scheduler cpuIntensiveScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, SchedulerPoolsConfigFactory poolsConfigFactory) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)poolsConfigFactory)).createCpuIntensiveScheduler(config, this.cpuBoundWorkers(), this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private int cpuBoundWorkers() {
        return 4 * CORES;
    }

    private int ioBoundWorkers() {
        return CORES * CORES;
    }

    @Override
    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config));
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    @Inject
    public Scheduler customScheduler(@Named(value="_muleSchedulerBaseConfig") SchedulerConfig config, int queueSize) {
        this.checkStarted();
        this.pollsReadLock.lock();
        try {
            Scheduler scheduler = ((SchedulerThreadPools)this.poolsByConfig.get((Object)SchedulerContainerPoolsConfig.getInstance())).createCustomScheduler(config, CORES, this.resolveStopTimeout(config), queueSize);
            return scheduler;
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e.getCause());
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    private Supplier<Long> resolveStopTimeout(SchedulerConfig config) {
        return () -> config.getShutdownTimeoutMillis().get() != null ? config.getShutdownTimeoutMillis().get() : Long.valueOf(5000L);
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Service " + this.getName() + " is not started.");
        }
    }

    @Override
    public void start() throws MuleException {
        this.pollsWriteLock.lock();
        try {
            this.containerThreadPoolsConfig = ContainerThreadPoolsConfig.loadThreadPoolsConfig();
            this.poolsByConfig = CacheBuilder.newBuilder().weakKeys().removalListener((RemovalListener)new RemovalListener<SchedulerPoolsConfigFactory, SchedulerThreadPools>(){

                public void onRemoval(RemovalNotification<SchedulerPoolsConfigFactory, SchedulerThreadPools> notification) {
                    try {
                        ((SchedulerThreadPools)notification.getValue()).stop();
                        logger.info("Stopped " + this.toString());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        logger.warn("Stop of " + this.toString() + " interrupted", (Throwable)e);
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }).build((CacheLoader)new CacheLoader<SchedulerPoolsConfigFactory, SchedulerThreadPools>(){

                public SchedulerThreadPools load(SchedulerPoolsConfigFactory key) throws Exception {
                    SchedulerThreadPools containerThreadPools = new SchedulerThreadPools(DefaultSchedulerService.this.getName(), key.getConfig().orElse(DefaultSchedulerService.this.containerThreadPoolsConfig));
                    containerThreadPools.start();
                    return containerThreadPools;
                }
            });
            this.started = true;
            this.poolsMaintenanceScheduler = this.customScheduler(SchedulerConfig.config().withName("Scheduler Maintenace").withMaxConcurrentTasks(1));
            this.poolsMaintenanceTask = this.poolsMaintenanceScheduler.scheduleAtFixedRate(() -> this.poolsByConfig.cleanUp(), 1L, 1L, TimeUnit.MINUTES);
            if (USAGE_TRACE_INTERVAL_SECS != null) {
                traceLogger.info("Usage Trace enabled");
                this.usageReportingTask = this.poolsMaintenanceScheduler.scheduleAtFixedRate(() -> {
                    traceLogger.warn("************************************************************************");
                    traceLogger.warn("* Schedulers Usage Report                                              *");
                    traceLogger.warn("************************************************************************");
                    for (SchedulerThreadPools pool : this.getPools()) {
                        traceLogger.warn(pool.buildReportString());
                        traceLogger.warn("************************************************************************");
                    }
                }, USAGE_TRACE_INTERVAL_SECS, USAGE_TRACE_INTERVAL_SECS, TimeUnit.SECONDS);
            }
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    @Override
    public void stop() throws MuleException {
        logger.info("Stopping " + this.toString() + "...");
        this.pollsWriteLock.lock();
        try {
            this.started = false;
            if (this.usageReportingTask != null) {
                this.usageReportingTask.cancel(true);
            }
            this.poolsMaintenanceTask.cancel(true);
            this.poolsMaintenanceScheduler.stop();
            this.poolsByConfig.invalidateAll();
            this.poolsByConfig = null;
            this.containerThreadPoolsConfig = null;
        }
        finally {
            this.pollsWriteLock.unlock();
        }
    }

    @Override
    public List<SchedulerView> getSchedulers() {
        ArrayList schedulers = new ArrayList();
        for (SchedulerThreadPools schedulerThreadPools : this.getPools()) {
            schedulers.addAll(schedulerThreadPools.getSchedulers().stream().map(s -> new DefaultSchedulerView((Scheduler)s)).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(schedulers);
    }

    public Collection<SchedulerThreadPools> getPools() {
        this.pollsReadLock.lock();
        try {
            this.poolsByConfig.cleanUp();
            Collection<SchedulerThreadPools> collection = this.poolsByConfig.asMap().values();
            return collection;
        }
        finally {
            this.pollsReadLock.unlock();
        }
    }

    @Override
    public String getSplashMessage() {
        StringBuilder splashMessage = new StringBuilder();
        splashMessage.append("Resolved configuration values:").append(System.lineSeparator());
        splashMessage.append("" + System.lineSeparator());
        splashMessage.append("gracefulShutdownTimeout:       ").append(this.containerThreadPoolsConfig.getGracefulShutdownTimeout().getAsLong() + " ms" + System.lineSeparator());
        splashMessage.append("cpuLight.threadPool.size:      ").append(this.containerThreadPoolsConfig.getCpuLightPoolSize().getAsInt() + System.lineSeparator());
        splashMessage.append("cpuLight.workQueue.size:       ").append(this.containerThreadPoolsConfig.getCpuLightQueueSize().getAsInt() + System.lineSeparator());
        splashMessage.append("io.threadPool.maxSize:         ").append(this.containerThreadPoolsConfig.getIoMaxPoolSize().getAsInt() + System.lineSeparator());
        splashMessage.append("io.threadPool.threadKeepAlive: ").append(this.containerThreadPoolsConfig.getIoKeepAlive().getAsLong() + " ms" + System.lineSeparator());
        splashMessage.append("cpuIntensive.threadPool.size:  ").append(this.containerThreadPoolsConfig.getCpuIntensivePoolSize().getAsInt() + System.lineSeparator());
        splashMessage.append("cpuIntensive.workQueue.size:   ").append(this.containerThreadPoolsConfig.getCpuIntensiveQueueSize().getAsInt() + System.lineSeparator());
        splashMessage.append("" + System.lineSeparator());
        splashMessage.append("These can be modified by editing 'conf/scheduler-pools.conf'" + System.lineSeparator());
        return splashMessage.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

