/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ExtensionModelHelper {
    private final Set<ExtensionModel> extensionsModels;
    private Cache<ComponentIdentifier, Optional<? extends org.mule.runtime.api.meta.model.ComponentModel>> extensionComponentModelByComponentIdentifier = CacheBuilder.newBuilder().build();

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels) {
        this.extensionsModels = extensionModels;
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentModel componentModel) {
        Optional<? extends org.mule.runtime.api.meta.model.ComponentModel> extensionComponentModelOptional = this.findComponentModel(componentModel.getCustomAttributes().containsKey("ORIGINAL_IDENTIFIER") ? (ComponentIdentifier)componentModel.getCustomAttributes().get("ORIGINAL_IDENTIFIER") : componentModel.getIdentifier());
        return extensionComponentModelOptional.map(extensionComponentModel -> {
            final Reference componentTypeReference = new Reference();
            extensionComponentModel.accept(new ComponentModelVisitor(){

                @Override
                public void visit(OperationModel model) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.OPERATION);
                }

                @Override
                public void visit(SourceModel model) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.SOURCE);
                }

                @Override
                public void visit(ConstructModel model) {
                    if (model.getStereotype().equals(MuleStereotypes.ERROR_HANDLER)) {
                        componentTypeReference.set(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                        return;
                    }
                    if (model.getStereotype().equals(MuleStereotypes.FLOW)) {
                        componentTypeReference.set(TypedComponentIdentifier.ComponentType.FLOW);
                        return;
                    }
                    NestedComponentVisitor nestedComponentVisitor = new NestedComponentVisitor(componentTypeReference);
                    for (NestableElementModel nestableElementModel : model.getNestedComponents()) {
                        nestableElementModel.accept(nestedComponentVisitor);
                        if (componentTypeReference.get() == null) continue;
                        return;
                    }
                }
            });
            return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)((Object)((Object)componentTypeReference.get()));
        }).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN);
    }

    public Optional<? extends org.mule.runtime.api.meta.model.ComponentModel> findComponentModel(ComponentIdentifier componentIdentifier) {
        try {
            return (Optional)this.extensionComponentModelByComponentIdentifier.get((Object)componentIdentifier, () -> {
                String componentName = NameUtils.toCamelCase(componentIdentifier.getName(), "-");
                for (ExtensionModel extensionModel : this.extensionsModels) {
                    if (!extensionModel.getXmlDslModel().getPrefix().equals(componentIdentifier.getNamespace())) continue;
                    ImmutableList operationModelsProviders = ImmutableList.builder().add((Object)extensionModel).addAll(extensionModel.getConfigurationModels()).build();
                    ImmutableList sourceModelsProviders = ImmutableList.builder().add((Object)extensionModel).addAll(extensionModel.getConfigurationModels()).build();
                    List<ExtensionModel> constructModelsProviders = Collections.singletonList(extensionModel);
                    Stream<Supplier> stream = Stream.of(() -> this.lambda$null$1((List)operationModelsProviders, (List)sourceModelsProviders, constructModelsProviders, componentName), () -> this.lambda$null$2((List)operationModelsProviders, (List)sourceModelsProviders, constructModelsProviders, componentIdentifier), () -> this.lambda$null$3((List)operationModelsProviders, (List)sourceModelsProviders, constructModelsProviders, componentName));
                    return stream.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
                }
                return Optional.empty();
            });
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Optional<? extends org.mule.runtime.api.meta.model.ComponentModel> resolveModel(List<HasOperationModels> operationModelsProviders, List<HasSourceModels> sourceModelsProviders, List<HasConstructModels> constructModelsProviders, String componentName) {
        for (HasOperationModels operationModelsProvider : operationModelsProviders) {
            Optional<OperationModel> operationModel = operationModelsProvider.getOperationModel(componentName);
            if (!operationModel.isPresent()) continue;
            return operationModel;
        }
        for (HasSourceModels sourceModelsProvider : sourceModelsProviders) {
            Optional<SourceModel> sourceModel = sourceModelsProvider.getSourceModel(componentName);
            if (!sourceModel.isPresent()) continue;
            return sourceModel;
        }
        for (HasConstructModels constructModelsProvider : constructModelsProviders) {
            Optional<ConstructModel> constructModel = constructModelsProvider.getConstructModel(componentName);
            if (!constructModel.isPresent()) continue;
            return constructModel;
        }
        return Optional.empty();
    }

    private /* synthetic */ Optional lambda$null$3(List operationModelsProviders, List sourceModelsProviders, List constructModelsProviders, String componentName) {
        return this.resolveModel(operationModelsProviders, sourceModelsProviders, constructModelsProviders, StringUtils.capitalize((String)componentName));
    }

    private /* synthetic */ Optional lambda$null$2(List operationModelsProviders, List sourceModelsProviders, List constructModelsProviders, ComponentIdentifier componentIdentifier) {
        return this.resolveModel(operationModelsProviders, sourceModelsProviders, constructModelsProviders, componentIdentifier.getName());
    }

    private /* synthetic */ Optional lambda$null$1(List operationModelsProviders, List sourceModelsProviders, List constructModelsProviders, String componentName) {
        return this.resolveModel(operationModelsProviders, sourceModelsProviders, constructModelsProviders, componentName);
    }

    static class NestedComponentVisitor
    implements NestableElementModelVisitor {
        private Reference<TypedComponentIdentifier.ComponentType> reference;

        public NestedComponentVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        @Override
        public void visit(NestedComponentModel component) {
        }

        @Override
        public void visit(NestedChainModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.SCOPE);
        }

        @Override
        public void visit(NestedRouteModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.ROUTER);
        }
    }
}

