/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.object.ListCursorIteratorProvider;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public final class StreamingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreEvent withCursoredEvent(CoreEvent event, final CheckedFunction<CoreEvent, CoreEvent> f) throws MuleException {
        if (event.getMessage().getPayload() == null) {
            return event;
        }
        final Reference<Throwable> exception = new Reference<Throwable>();
        CheckedFunction<CoreEvent, CoreEvent> function = new CheckedFunction<CoreEvent, CoreEvent>(){

            @Override
            public CoreEvent applyChecked(CoreEvent event) throws Throwable {
                return (CoreEvent)f.apply(event);
            }

            @Override
            public CoreEvent handleException(Throwable throwable) {
                exception.set(Exceptions.unwrap(throwable));
                return null;
            }
        };
        Object payload = event.getMessage().getPayload().getValue();
        CursorProvider cursorProvider = null;
        Cursor cursor = null;
        try {
            CoreEvent value;
            if (payload instanceof CursorProvider) {
                cursorProvider = (CursorProvider)payload;
                cursor = (Cursor)cursorProvider.openCursor();
                event = StreamingUtils.replacePayload(event, cursor);
            }
            if ((value = (CoreEvent)function.apply(event)) == null) {
                StreamingUtils.handlePossibleException(exception);
            } else if (value.getMessage().getPayload().getValue() == cursor) {
                value = StreamingUtils.replacePayload(value, cursorProvider);
            }
            CoreEvent coreEvent = value;
            return coreEvent;
        }
        finally {
            if (cursor != null) {
                StreamingUtils.closeQuietly(cursor);
            }
        }
    }

    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, EventContext eventContext) {
        if (cursorProviderFactory != null && cursorProviderFactory.accepts(value)) {
            return cursorProviderFactory.of(eventContext, value);
        }
        return value;
    }

    public static Object streamingContent(Object value, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        return StreamingUtils.streamingContent(value, cursorProviderFactory, ((BaseEventContext)event.getContext()).getRootContext());
    }

    public static boolean closeQuietly(Cursor cursor) {
        if (cursor == null) {
            return false;
        }
        try {
            cursor.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static <T> CursorIteratorProvider asCursorProvider(List<T> items) {
        return new ListCursorIteratorProvider(items);
    }

    public static CursorStreamProvider asCursorProvider(byte[] bytes) {
        return new ByteArrayCursorStreamProvider(bytes);
    }

    public static CoreEvent consumeRepeatablePayload(CoreEvent event) {
        TypedValue payload = event.getMessage().getPayload();
        Object originalPayload = payload.getValue();
        if (originalPayload == null) {
            return event;
        }
        DataType originalDataType = payload.getDataType();
        TypedValue<Object> replacedPayload = null;
        if (originalPayload instanceof CursorStreamProvider) {
            CursorStreamProvider consumedPayload = StreamingUtils.asCursorProvider(IOUtils.toByteArray((CursorStreamProvider)originalPayload));
            replacedPayload = new TypedValue<CursorStreamProvider>(consumedPayload, DataType.builder(originalDataType).type(consumedPayload.getClass()).build());
        } else if (originalPayload instanceof CursorIteratorProvider) {
            DataType newDataType;
            LinkedList consumed = new LinkedList();
            ((CursorIterator)((CursorIteratorProvider)originalPayload).openCursor()).forEachRemaining(consumed::add);
            if (originalDataType instanceof CollectionDataType) {
                CollectionDataType collectionDataType = (CollectionDataType)originalDataType;
                newDataType = DataType.builder(originalDataType).collectionType(consumed.getClass()).itemType(collectionDataType.getItemDataType().getType()).itemMediaType(collectionDataType.getItemDataType().getMediaType()).build();
            } else {
                newDataType = DataType.builder(originalDataType).type(consumed.getClass()).build();
            }
            replacedPayload = new TypedValue(consumed, newDataType);
        }
        if (replacedPayload != null) {
            event = CoreEvent.builder(event).message(Message.builder(event.getMessage()).payload(replacedPayload).build()).build();
        }
        return event;
    }

    private static CoreEvent replacePayload(CoreEvent event, Object newPayload) {
        return CoreEvent.builder(event).message(Message.builder(event.getMessage()).value(newPayload).build()).build();
    }

    private static void handlePossibleException(Reference<Throwable> exception) throws MuleException {
        Throwable t = exception.get();
        if (t != null) {
            throw Exceptions.rxExceptionToMuleException(t);
        }
    }

    private StreamingUtils() {
    }

    public static TypedValue updateTypedValueForStreaming(TypedValue value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        Object payload = value.getValue();
        if (payload instanceof CursorProvider) {
            CursorProvider cursorProvider = streamingManager.manage((CursorProvider)payload, (EventContext)((BaseEventContext)event.getContext()).getRootContext());
            if (cursorProvider == payload) {
                return value;
            }
            DataType dataType = DataType.builder(value.getDataType()).type(cursorProvider.getClass()).build();
            return new TypedValue<CursorProvider>(cursorProvider, dataType, value.getByteLength());
        }
        return value;
    }

    public static Function<CoreEvent, CoreEvent> updateEventForStreaming(StreamingManager streamingManager) {
        return event -> {
            TypedValue payload = event.getMessage().getPayload();
            if (payload.getValue() instanceof CursorProvider) {
                TypedValue updatedPayload = StreamingUtils.updateTypedValueForStreaming(payload, event, streamingManager);
                if (updatedPayload == payload) {
                    return event;
                }
                Message message = Message.builder(event.getMessage()).payload(updatedPayload).build();
                return CoreEvent.builder(event).message(message).build();
            }
            return event;
        };
    }

    public static TypedValue updateTypedValueWithCursorProvider(TypedValue value, CoreEvent event, StreamingManager streamingManager) {
        if (event == null) {
            return value;
        }
        Object payload = value.getValue();
        if (payload instanceof CursorStream) {
            CursorProvider provider = ((CursorStream)value.getValue()).getProvider();
            DataType dataType = DataType.builder(value.getDataType()).type(provider.getClass()).build();
            return new TypedValue<CursorProvider>(provider, dataType, value.getByteLength());
        }
        return value;
    }

    public static boolean supportsStreaming(ComponentModel componentModel) {
        return componentModel instanceof ConnectableComponentModel && ((ConnectableComponentModel)componentModel).supportsStreaming();
    }
}

