/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.builders;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public class DefaultsConfigurationBuilder
extends AbstractConfigurationBuilder {
    @Override
    protected void doConfigure(MuleContext muleContext) throws Exception {
        MuleRegistry registry = ((MuleContextWithRegistries)muleContext).getRegistry();
        new SimpleRegistryBootstrap(ArtifactType.APP, muleContext).initialise();
        this.configureQueueManager(muleContext);
        registry.registerObject("_muleContext", muleContext);
        this.registerObject("_muleSecurityManager", new DefaultMuleSecurityManager(), muleContext);
        this.registerObject("_defaultInMemoryObjectStore", DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore(), muleContext);
        this.registerObject("_defaultPersistentObjectStore", DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore(), muleContext);
        this.registerLocalObjectStoreManager(muleContext, registry);
        this.registerObject("_muleSchedulerPoolsConfig", SchedulerContainerPoolsConfig.getInstance(), muleContext);
        this.registerObject("_muleSchedulerBaseConfig", SchedulerConfig.config().withPrefix(muleContext.getConfiguration().getId()).withShutdownTimeout(() -> muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS), muleContext);
        this.registerObject("_muleObjectStoreManager", new MuleObjectStoreManager(), muleContext);
        this.registerObject("_muleMessageProcessingManager", new MuleMessageProcessingManager(), muleContext);
        this.registerObject("_muleStreamCloserService", new DefaultStreamCloserService(), muleContext);
        this.registerObject("_muleLockProvider", new SingleServerLockProvider(), muleContext);
        this.registerObject("_muleLockFactory", new MuleLockFactory(), muleContext);
        this.registerObject("_muleProcessingTimeWatcher", new DefaultProcessingTimeWatcher(), muleContext);
        this.registerObject("_defaultRetryPolicyTemplate", new NoRetryPolicyTemplate(), muleContext);
        this.registerObject("_converterResolver", new DynamicDataTypeConversionResolver(muleContext), muleContext);
        this.registerObject("_muleDefaultObjectSerializer", new JavaObjectSerializer(), muleContext);
        this.registerObject("_muleExpressionLanguage", new MVELExpressionLanguage(muleContext), muleContext);
        DefaultStreamingManager streamingManager = new DefaultStreamingManager();
        this.registerObject("_muleStreamingManager", streamingManager, muleContext);
        this.registerObject("_muleExpressionManager", new DefaultExpressionManager(), muleContext);
        this.registerObject("_muleTimeSupplier", new LocalTimeSupplier(), muleContext);
        this.registerObject("_muleConnectionManager", new DefaultConnectionManager(muleContext), muleContext);
        this.registerObject("_muleMetadataService", new MuleMetadataService(), muleContext);
        this.registerObject("_muleValueProviderService", new MuleValueProviderService(), muleContext);
        this.registerObject("_muleProcessorInterceptorManager", new DefaultProcessorInterceptorManager(), muleContext);
        this.registerObject("_muleNotificationDispatcher", new DefaultNotificationDispatcher(), muleContext);
        this.registerObject("_muleNotificationListenerRegistry", new DefaultNotificationListenerRegistry(), muleContext);
        this.registerObject("_muleEventContextService", new DefaultEventContextService(), muleContext);
        this.registerObject("_muleTransactionFactoryLocator", new TransactionFactoryLocator(), muleContext);
        this.registerObject("_muleComponentInitialStateManager", new ComponentInitialStateManager(){

            @Override
            public boolean mustStartMessageSource(Component component) {
                return true;
            }
        }, muleContext);
    }

    protected void registerObject(String serviceId, Object serviceImpl, MuleContext muleContext) throws RegistrationException {
        if (serviceImpl instanceof MuleContextAware) {
            ((MuleContextAware)serviceImpl).setMuleContext(muleContext);
        }
        ((MuleContextWithRegistries)muleContext).getRegistry().registerObject(serviceId, serviceImpl);
    }

    private void registerLocalObjectStoreManager(MuleContext muleContext, MuleRegistry registry) throws RegistrationException {
        MuleObjectStoreManager osm = new MuleObjectStoreManager();
        osm.setBasePersistentStoreKey("_defaultPersistentObjectStore");
        osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
        osm.setMuleContext(muleContext);
        registry.registerObject("_muleObjectStoreManager", osm);
    }

    protected void configureQueueManager(MuleContext muleContext) throws RegistrationException {
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        this.registerObject("_muleQueueManager", queueManager, muleContext);
        this.registerObject("_localQueueManager", queueManager, muleContext);
    }
}

