/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.internal.config.ConfigurationInstanceNotification;
import org.mule.runtime.core.internal.metadata.DefaultMetadataCache;
import org.mule.runtime.core.internal.metadata.InvalidComponentIdException;

public class MuleMetadataService
implements MetadataService,
Initialisable {
    private static final String COMPONENT_NOT_METADATA_PROVIDER = "Component [%s] is not a MetadataProvider or MetadataEntityProvider, no information available";
    private static final String COMPONENT_NOT_METADATA_KEY_PROVIDER = "Component [%s] is not a MetadataKeyProvider, no information available";
    private static final String EXCEPTION_RESOLVING_COMPONENT_METADATA = "An exception occurred while resolving metadata for component '%s'";
    private static final String EXCEPTION_RESOLVING_METADATA_KEYS = "An exception occurred while resolving Component MetadataKeys";
    @Inject
    private NotificationListenerRegistry notificationRegistrer;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    private final LoadingCache<String, MetadataCache> caches = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, MetadataCache>(){

        public MetadataCache load(String id) throws Exception {
            return new DefaultMetadataCache();
        }
    });

    @Override
    public void initialise() throws InitialisationException {
        this.notificationRegistrer.registerListener(notification -> {
            try {
                if (notification.getAction().getActionId() == ConfigurationInstanceNotification.CONFIGURATION_STOPPED) {
                    String name = ((ConfigurationInstanceNotification)notification).getConfigurationInstance().getName();
                    this.disposeCache(name);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error while looking for the MetadataManager in the registry", e);
            }
        });
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataKeyProvider(location).getMetadataKeys(), EXCEPTION_RESOLVING_METADATA_KEYS);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location, MetadataKey key) {
        return this.getComponentMetadataWithKey(location, key);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
        return this.getComponentMetadata(location);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location, MetadataKey key) {
        return this.getComponentMetadataWithKey(location, key);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
        return this.getComponentMetadata(location);
    }

    @Override
    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(Location location, MetadataKey key) {
        return this.exceptionHandledMetadataFetch(() -> this.findEntityMetadataProvider(location).getEntityMetadata(key), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, location));
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getEntityKeys(Location location) {
        return this.exceptionHandledMetadataFetch(() -> this.findEntityMetadataProvider(location).getEntityKeys(), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, location));
    }

    @Override
    public void disposeCache(String id) {
        this.caches.invalidate((Object)id);
    }

    public MetadataCache getMetadataCache(String id) {
        try {
            return (MetadataCache)this.caches.get((Object)id);
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not get the cache with id:" + id), (Throwable)e);
        }
    }

    public Map<String, ? extends MetadataCache> getMetadataCaches() {
        return ImmutableMap.copyOf((Map)this.caches.asMap());
    }

    private <T> MetadataResult<T> exceptionHandledMetadataFetch(MetadataDelegate<T> producer, String failureMessage) {
        try {
            return producer.get();
        }
        catch (InvalidComponentIdException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).withFailureCode(e.getFailureCode()).onComponent());
        }
        catch (Exception e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    private MetadataKeyProvider findMetadataKeyProvider(Location location) throws InvalidComponentIdException {
        try {
            return (MetadataKeyProvider)this.findComponent(location);
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage(String.format(COMPONENT_NOT_METADATA_KEY_PROVIDER, location)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private Object findComponent(Location location) throws InvalidComponentIdException {
        return this.componentLocator.find(location).orElseThrow(() -> new InvalidComponentIdException(I18nMessageFactory.createStaticMessage("No object found with location " + location), FailureCode.COMPONENT_NOT_FOUND));
    }

    private <T extends ComponentModel> MetadataProvider<T> findMetadataProvider(Location location) throws InvalidComponentIdException {
        try {
            return (MetadataProvider)this.findComponent(location);
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage(String.format(COMPONENT_NOT_METADATA_PROVIDER, location)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private EntityMetadataProvider findEntityMetadataProvider(Location location) throws InvalidComponentIdException {
        try {
            return (EntityMetadataProvider)this.findComponent(location);
        }
        catch (ClassCastException e) {
            throw new InvalidComponentIdException(I18nMessageFactory.createStaticMessage(String.format(COMPONENT_NOT_METADATA_PROVIDER, location)), FailureCode.NO_DYNAMIC_METADATA_AVAILABLE);
        }
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getComponentMetadata(Location location) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataProvider(location).getMetadata(), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, location));
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getComponentMetadataWithKey(Location location, MetadataKey key) {
        return this.exceptionHandledMetadataFetch(() -> this.findMetadataProvider(location).getMetadata(key), String.format(EXCEPTION_RESOLVING_COMPONENT_METADATA, location));
    }

    @FunctionalInterface
    private static interface MetadataDelegate<T> {
        public MetadataResult<T> get() throws MetadataResolvingException, InvalidComponentIdException;
    }
}

