/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyProvider;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.SourcePolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.policy.CompositeOperationPolicy;
import org.mule.runtime.core.internal.policy.CompositeSourcePolicy;
import org.mule.runtime.core.internal.policy.DefaultOperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.DefaultSourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NullPolicyProvider;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.OperationPolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.PolicyPointcutParametersManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicyProcessorFactory;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;
import reactor.core.publisher.Mono;

public class DefaultPolicyManager
implements PolicyManager,
Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private PolicyStateHandler policyStateHandler;
    @Inject
    private StreamingManager streamingManager;
    private Collection<OperationPolicyParametersTransformer> operationPolicyParametersTransformerCollection = Collections.emptyList();
    private Collection<SourcePolicyParametersTransformer> sourcePolicyParametersTransformerCollection = Collections.emptyList();
    private PolicyProvider policyProvider;
    private OperationPolicyProcessorFactory operationPolicyProcessorFactory;
    private SourcePolicyProcessorFactory sourcePolicyProcessorFactory;
    private PolicyPointcutParametersManager policyPointcutParametersManager;

    @Override
    public SourcePolicy createSourcePolicyInstance(Component source, CoreEvent sourceEvent, Processor flowExecutionProcessor, MessageSourceResponseParametersProcessor messageSourceResponseParametersProcessor) {
        PolicyPointcutParameters sourcePointcutParameters = this.policyPointcutParametersManager.createSourcePointcutParameters(source, sourceEvent);
        List<Policy> parameterizedPolicies = this.policyProvider.findSourceParameterizedPolicies(sourcePointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return event -> Mono.from(MessageProcessors.process(event, flowExecutionProcessor)).switchIfEmpty(Mono.fromSupplier(() -> CoreEvent.builder(sourceEvent).message(Message.of(null)).build())).map(flowExecutionResult -> Either.right(new SourcePolicySuccessResult((CoreEvent)flowExecutionResult, () -> messageSourceResponseParametersProcessor.getSuccessfulExecutionResponseParametersFunction().apply((CoreEvent)flowExecutionResult), messageSourceResponseParametersProcessor))).onErrorResume(Exception.class, e -> {
                MessagingException messagingException = e instanceof MessagingException ? (MessagingException)e : new MessagingException(event, (Throwable)e, (Component)((Object)flowExecutionProcessor));
                return Mono.just(Either.left(new SourcePolicyFailureResult(messagingException, () -> messageSourceResponseParametersProcessor.getFailedExecutionResponseParametersFunction().apply(messagingException.getEvent()))));
            });
        }
        return new CompositeSourcePolicy(parameterizedPolicies, this.lookupSourceParametersTransformer(source.getLocation().getComponentIdentifier().getIdentifier()), this.sourcePolicyProcessorFactory, flowExecutionProcessor, messageSourceResponseParametersProcessor);
    }

    @Override
    public OperationPolicy createOperationPolicy(Component operation, CoreEvent event, Map<String, Object> operationParameters, OperationExecutionFunction operationExecutionFunction) {
        PolicyPointcutParameters operationPointcutParameters = this.policyPointcutParametersManager.createOperationPointcutParameters(operation, event, operationParameters);
        List<Policy> parameterizedPolicies = this.policyProvider.findOperationParameterizedPolicies(operationPointcutParameters);
        if (parameterizedPolicies.isEmpty()) {
            return operationEvent -> operationExecutionFunction.execute(operationParameters, operationEvent);
        }
        return new CompositeOperationPolicy(parameterizedPolicies, this.lookupOperationParametersTransformer(operation.getLocation().getComponentIdentifier().getIdentifier()), this.operationPolicyProcessorFactory, () -> operationParameters, operationExecutionFunction, this.streamingManager);
    }

    private Optional<OperationPolicyParametersTransformer> lookupOperationParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.operationPolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    private Optional<SourcePolicyParametersTransformer> lookupSourceParametersTransformer(ComponentIdentifier componentIdentifier) {
        return this.sourcePolicyParametersTransformerCollection.stream().filter(policyOperationParametersTransformer -> policyOperationParametersTransformer.supports(componentIdentifier)).findAny();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.operationPolicyProcessorFactory = new DefaultOperationPolicyProcessorFactory(this.policyStateHandler);
        this.sourcePolicyProcessorFactory = new DefaultSourcePolicyProcessorFactory(this.policyStateHandler);
        MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
        this.policyProvider = registry.lookupLocalObjects(PolicyProvider.class).stream().findFirst().orElse(new NullPolicyProvider());
        this.sourcePolicyParametersTransformerCollection = registry.lookupObjects(SourcePolicyParametersTransformer.class);
        this.operationPolicyParametersTransformerCollection = registry.lookupObjects(OperationPolicyParametersTransformer.class);
        this.policyPointcutParametersManager = new PolicyPointcutParametersManager(registry.lookupObjects(SourcePolicyPointcutParametersFactory.class), registry.lookupObjects(OperationPolicyPointcutParametersFactory.class));
    }

    @Override
    public void disposePoliciesResources(String executionIdentifier) {
        this.policyStateHandler.destroyState(executionIdentifier);
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

