/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message.response;

import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.mule.runtime.http.api.domain.message.HttpMessageBuilder;
import org.mule.runtime.http.api.domain.message.response.DefaultHttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.ResponseStatus;
import org.mule.runtime.http.api.server.HttpServerProperties;

public final class HttpResponseBuilder
extends HttpMessageBuilder<HttpResponseBuilder, HttpResponse> {
    private ResponseStatus responseStatus = new ResponseStatus();

    HttpResponseBuilder() {
    }

    public HttpResponseBuilder(HttpResponse httpResponse) {
        super(httpResponse);
        this.responseStatus(httpResponse);
    }

    @Override
    protected void initHeaders() {
        this.headers = new CaseInsensitiveMultiMap(!HttpServerProperties.PRESERVE_HEADER_CASE);
    }

    private void responseStatus(HttpResponse httpResponse) {
        this.statusCode(httpResponse.getStatusCode());
        this.reasonPhrase(httpResponse.getReasonPhrase());
    }

    public HttpResponseBuilder statusCode(Integer statusCode) {
        this.responseStatus.setStatusCode(statusCode);
        return this;
    }

    public HttpResponseBuilder reasonPhrase(String reasonPhrase) {
        this.responseStatus.setReasonPhrase(reasonPhrase);
        return this;
    }

    public int getStatusCode() {
        return this.responseStatus.getStatusCode();
    }

    public String getReasonPhrase() {
        return this.responseStatus.getReasonPhrase();
    }

    @Override
    public HttpResponse build() {
        return new DefaultHttpResponse(this.responseStatus, this.headers.toImmutableMultiMap(), this.entity);
    }
}

