/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;

class RouteElementDeclarationTypeAdapter
extends TypeAdapter<RouteElementDeclaration> {
    private final Gson delegate;

    RouteElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, RouteElementDeclaration route) throws IOException {
        if (route != null) {
            out.beginObject();
            ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, route, "ROUTE");
            out.name("components").jsonValue(this.delegate.toJson(route.getComponents()));
            out.endObject();
        }
    }

    public RouteElementDeclaration read(JsonReader in) throws IOException {
        JsonObject jsonObject;
        JsonElement elementKind;
        JsonElement parse;
        if (in != null && (parse = new JsonParser().parse(in)).isJsonObject() && (elementKind = (jsonObject = parse.getAsJsonObject()).get("kind")) != null && elementKind.getAsString().equals("ROUTE")) {
            String name = jsonObject.get("name").getAsString();
            String declaringExtension = jsonObject.get("declaringExtension").getAsString();
            JsonArray components = jsonObject.get("components").getAsJsonArray();
            RouteElementDeclarer declarer = ElementDeclarer.forExtension(declaringExtension).newRoute(name);
            ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, declarer);
            components.forEach(c -> declarer.withComponent((ComponentElementDeclaration)this.delegate.fromJson(c, ComponentElementDeclaration.class)));
            return (RouteElementDeclaration)declarer.getDeclaration();
        }
        return null;
    }
}

