/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ParameterGroupObjectBuilder<T>
extends DefaultObjectBuilder<T> {
    private final ParameterGroupDescriptor groupDescriptor;

    public ParameterGroupObjectBuilder(ParameterGroupDescriptor groupDescriptor, ReflectionCache reflectionCache) {
        super(groupDescriptor.getType().getDeclaringClass().get(), reflectionCache);
        this.groupDescriptor = groupDescriptor;
    }

    public T build(EventedExecutionContext executionContext) throws MuleException {
        return this.doBuild(executionContext::hasParameter, executionContext::getParameter, ValueResolvingContext.from(executionContext.getEvent(), executionContext.getConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T build(ResolverSetResult result) throws MuleException {
        Map<String, Object> resultMap = result.asMap();
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = MuleExtensionUtils.getInitialiserEvent();
            T t = this.doBuild(resultMap::containsKey, resultMap::get, ValueResolvingContext.from(initialiserEvent));
            return t;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    private T doBuild(Predicate<String> hasParameter, Function<String, Object> parameters, ValueResolvingContext context) throws MuleException {
        this.reflectionCache.fieldElementsFor(this.groupDescriptor).forEach(field -> {
            String name = field.getName();
            if (hasParameter.test(name)) {
                this.addPropertyResolver(name, new StaticValueResolver(parameters.apply(name)));
            }
        });
        return this.build(context);
    }
}

