/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.AcceptsAllMethodsRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.ListenerRequestMatcher;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpConstants.Protocol protocol;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer, HttpConstants.Protocol protocol) {
        this.serverAddress = serverAddress;
        this.protocol = protocol;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
    }

    @Override
    public synchronized HttpServer start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.serverConnection.addCloseListener((closeable, type) -> {
            try {
                this.scheduler.stop();
            }
            finally {
                this.scheduler = null;
            }
            this.schedulerDisposer.run();
        });
        this.stopped = false;
        return this;
    }

    @Override
    public synchronized HttpServer stop() {
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
            GrizzlyHttpServer grizzlyHttpServer = this;
            return grizzlyHttpServer;
        }
        finally {
            this.stopping = false;
            this.stopped = true;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public HttpConstants.Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, new ListenerRequestMatcher(new DefaultMethodRequestMatcher(methods.toArray(new String[methods.size()])), path));
    }

    @Override
    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, requestHandler, new ListenerRequestMatcher(AcceptsAllMethodsRequestMatcher.instance(), path));
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }
}

