/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.csv.writer;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import org.mule.weave.v2.exception.WriterExecutionException;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.ArraySeq;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.ConfigurableReaderWriter;
import org.mule.weave.v2.module.csv.reader.parser.CSVSettingsHelper;
import org.mule.weave.v2.module.csv.reader.parser.CSVWriterSettings;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.Location;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001E\u0011\u0011bQ*W/JLG/\u001a:\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u0005\u00191m\u001d<\u000b\u0005\u001dA\u0011AB7pIVdWM\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\tQa^3bm\u0016T!!\u0004\b\u0002\t5,H.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\tI2$D\u0001\u001b\u0015\t\u0019a!\u0003\u0002\u001d5\t1qK]5uKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0003_N\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0005%|'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012AbT;uaV$8\u000b\u001e:fC6D\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!K\u0001\tg\u0016$H/\u001b8hgV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u00051\u0001/\u0019:tKJT!a\f\u0003\u0002\rI,\u0017\rZ3s\u0013\t\tDFA\tD'Z;&/\u001b;feN+G\u000f^5oOND\u0001b\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\ng\u0016$H/\u001b8hg\u0002B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006YAN\u0001\u0004GRD\bCA\u001c;\u001b\u0005A$BA\u001d\t\u0003\u0015iw\u000eZ3m\u0013\tY\u0004HA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDcA D\tR\u0011\u0001I\u0011\t\u0003\u0003\u0002i\u0011A\u0001\u0005\u0006kq\u0002\u001dA\u000e\u0005\u0006=q\u0002\ra\b\u0005\u0006Qq\u0002\rA\u000b\u0005\t\u0007\u0001A)\u0019!C\u0001\rV\tq\t\u0005\u0002!\u0011&\u0011\u0011*\t\u0002\u000f\u0005V4g-\u001a:fI^\u0013\u0018\u000e^3s\u0011!Y\u0005\u0001#b\u0001\n\u0003a\u0015!C2tm\u0016\u001b8-\u00199f+\u0005i\u0005CA\u0016O\u0013\tyEFA\tD'Z\u001bV\r\u001e;j]\u001e\u001c\b*\u001a7qKJDQ!\u0015\u0001\u0005BI\u000baA]3tk2$X#A*\u0011\u0005M!\u0016BA+\u0015\u0005\r\te.\u001f\u0005\u0006/\u0002!\t\u0005W\u0001\rI><&/\u001b;f-\u0006dW/\u001a\u000b\u00033z#\"AW/\u0011\u0005MY\u0016B\u0001/\u0015\u0005\u0011)f.\u001b;\t\u000bU2\u00069\u0001\u001c\t\u000b}3\u0006\u0019\u00011\u0002\u000bY\fG.^31\u0005\u0005L\u0007c\u00012fO6\t1M\u0003\u0002eq\u00051a/\u00197vKNL!AZ2\u0003\u000bY\u000bG.^3\u0011\u0005!LG\u0002\u0001\u0003\nUz\u000b\t\u0011!A\u0003\u0002-\u00141a\u0018\u00132#\ta7\u000b\u0005\u0002\u0014[&\u0011a\u000e\u0006\u0002\b\u001d>$\b.\u001b8h\u0011\u0015\u0001\b\u0001\"\u0001r\u0003-9(/\u001b;f\u0011\u0016\fG-\u001a:\u0015\u0005I$HC\u0001.t\u0011\u0015)t\u000eq\u00017\u0011\u0015yv\u000e1\u0001va\t1\b\u0010E\u0002cK^\u0004\"\u0001\u001b=\u0005\u0013e$\u0018\u0011!A\u0001\u0006\u0003Y'aA0%e!)1\u0010\u0001C\u0001y\u0006AqO]5uK\u000e\u001bf\u000b\u0006\u0002~\u007fR\u0011!L \u0005\u0006ki\u0004\u001dA\u000e\u0005\b\u0003\u0003Q\b\u0019AA\u0002\u0003!IG/\u001a:bi>\u0014\bCBA\u0003\u0003+\tYB\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055\u0001#\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u00111\u0003\u000b\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005!IE/\u001a:bi>\u0014(bAA\n)A\"\u0011QDA\u0011!\u0011\u0011W-a\b\u0011\u0007!\f\t\u0003\u0002\u0006\u0002$}\f\t\u0011!A\u0003\u0002-\u00141a\u0018\u00134\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\t!b\u001e:ji\u0016,e\u000e\u001e:z)\u0011\tY#a\f\u0015\u0007i\u000bi\u0003\u0003\u00046\u0003K\u0001\u001dA\u000e\u0005\b?\u0006\u0015\u0002\u0019AA\u0019a\u0011\t\u0019$a\u000e\u0011\t\t,\u0017Q\u0007\t\u0004Q\u0006]BaCA\u001d\u0003_\t\t\u0011!A\u0003\u0002-\u00141a\u0018\u00136\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007f\t1b\u001e:ji\u0016\u0014VmY8sIR!\u0011\u0011IA#)\rQ\u00161\t\u0005\u0007k\u0005m\u00029\u0001\u001c\t\u0011\u0005\u0005\u00111\ba\u0001\u0003\u000f\u0002b!!\u0002\u0002\u0016\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=\u0003(A\u0005tiJ,8\r^;sK&!\u00111KA'\u00051YU-\u001f,bYV,\u0007+Y5s\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n\u0011b]3qCJ\fGo\u001c:\u0016\u0005\u0005m\u0003cA\n\u0002^%\u0019\u0011q\f\u000b\u0003\t\rC\u0017M\u001d\u0005\b\u0003G\u0002A\u0011IA3\u0003\u0015\u0019Gn\\:f)\u0005Q\u0006bBA5\u0001\u0011\u0005\u0013QM\u0001\u0006M2,8\u000f\u001b")
public class CSVWriter
implements Writer {
    private BufferedWriter writer;
    private CSVSettingsHelper csvEscape;
    private final OutputStream os;
    private final CSVWriterSettings settings;
    private final EvaluationContext ctx;
    private volatile byte bitmap$0;

    @Override
    public void startDocument(LocationCapable location) {
        Writer.startDocument$(this, location);
    }

    @Override
    public void defineNamespace(LocationCapable location, String prefix, String uri) {
        Writer.defineNamespace$(this, location, prefix, uri);
    }

    @Override
    public final void writeValue(Value<?> value, EvaluationContext ctx) {
        Writer.writeValue$(this, value, ctx);
    }

    @Override
    public String getName() {
        return Writer.getName$(this);
    }

    @Override
    public final void endDocument(LocationCapable location) {
        Writer.endDocument$(this, location);
    }

    @Override
    public void doEndDocument(LocationCapable location) {
        Writer.doEndDocument$(this, location);
    }

    @Override
    public void setOption(Location location, String optionName, Object value) {
        ConfigurableReaderWriter.setOption$(this, location, optionName, value);
    }

    @Override
    public CSVWriterSettings settings() {
        return this.settings;
    }

    private BufferedWriter writer$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.writer = new BufferedWriter(new OutputStreamWriter(this.os, this.settings().charset(this.ctx)), this.settings().bufferSize());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        this.ctx = null;
        return this.writer;
    }

    public BufferedWriter writer() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private CSVSettingsHelper csvEscape$lzycompute() {
        CSVWriter cSVWriter = this;
        synchronized (cSVWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.csvEscape = new CSVSettingsHelper(this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.csvEscape;
    }

    public CSVSettingsHelper csvEscape() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.csvEscape$lzycompute() : this.csvEscape;
    }

    @Override
    public Object result() {
        return this.os;
    }

    @Override
    public void doWriteValue(Value<?> value, EvaluationContext ctx) {
        Value<?> value2 = value;
        if (value.valueType(ctx).isInstanceOf(ObjectType$.MODULE$, ctx)) {
            this.writeCSV(((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (value.valueType(ctx).isInstanceOf(ArrayType$.MODULE$, ctx)) {
            this.writeCSV(((ArraySeq)ArrayType$.MODULE$.coerce(value2, ctx).evaluate(ctx)).toIterator(), ctx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new WriterExecutionException(value.location(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV Structure should be and Array<Object> or Object but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value.valueType(ctx)})));
        }
    }

    public void writeHeader(Value<?> value, EvaluationContext ctx) {
        ObjectSeq evaluate = (ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        BooleanRef first = BooleanRef.create((boolean)true);
        evaluate.toIterator(ctx).foreach((Function1 & Serializable & scala.Serializable)kvv -> {
            CSVWriter.$anonfun$writeHeader$1(this, ctx, first, kvv);
            return BoxedUnit.UNIT;
        });
        this.writer().write(this.settings().lineSeparator());
    }

    public void writeCSV(Iterator<Value<?>> iterator, EvaluationContext ctx) {
        boolean first = true;
        while (iterator.hasNext()) {
            Value value = ((Value)iterator.next()).materialize(ctx);
            if (this.settings().header() && first) {
                value = value.materialize(ctx);
                this.writeHeader(value, ctx);
            }
            this.writeRecord(((ObjectSeq)ObjectType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toIterator(ctx), ctx);
            first = false;
        }
    }

    public void writeEntry(Value<?> value, EvaluationContext ctx) {
        block4: {
            boolean quoteValues;
            Option<Object> quote = this.settings().quote();
            boolean bl = quoteValues = this.settings().quoteValues() && quote.isDefined();
            if (quoteValues) {
                this.writer().write(BoxesRunTime.unboxToChar((Object)quote.get()));
            }
            if (!value.valueType(ctx).isInstanceOf(NullType$.MODULE$, ctx)) {
                String stringValue = (String)StringType$.MODULE$.withSchema(value.valueType(ctx).schema(ctx)).coerce(value, ctx).evaluate(ctx);
                if (quoteValues) {
                    this.writer().write(this.csvEscape().escapeQuotedString(stringValue));
                } else {
                    this.writer().write(this.csvEscape().escapeUnquotedString(stringValue));
                }
            }
            if (!quoteValues) break block4;
            this.writer().write(BoxesRunTime.unboxToChar((Object)quote.get()));
        }
    }

    public void writeRecord(Iterator<KeyValuePair> iterator, EvaluationContext ctx) {
        int index = 0;
        while (iterator.hasNext()) {
            KeyValuePair kvp = (KeyValuePair)iterator.next();
            if (index > 0) {
                this.writer().write(this.separator());
            }
            this.writeEntry((Value<?>)kvp._2(), ctx);
            ++index;
        }
        this.writer().write(this.settings().lineSeparator());
    }

    public char separator() {
        return this.settings().separator();
    }

    @Override
    public void close() {
        this.writer().close();
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    public static final /* synthetic */ void $anonfun$writeHeader$1(CSVWriter $this, EvaluationContext ctx$1, BooleanRef first$1, KeyValuePair kvv) {
        String name = ((QualifiedName)kvv._1().evaluate(ctx$1)).name();
        if (!first$1.elem) {
            $this.writer().write($this.separator());
        }
        if ($this.settings().quoteHeader()) {
            $this.writer().write("\"" + name + "\"");
        } else {
            $this.writer().write(name);
        }
        first$1.elem = false;
    }

    public CSVWriter(OutputStream os, CSVWriterSettings settings, EvaluationContext ctx) {
        this.os = os;
        this.settings = settings;
        this.ctx = ctx;
        ConfigurableReaderWriter.$init$(this);
        Writer.$init$(this);
    }
}

