/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.util.ClassUtils;

public class SpringConfigurationComponentLocator
implements ConfigurationComponentLocator {
    private final Function<String, Boolean> isTemplateLocationFunction;
    private final Map<String, Component> componentsMap = new HashMap<String, Component>();
    private final Set<ComponentLocation> componentLocations = new HashSet<ComponentLocation>();

    public SpringConfigurationComponentLocator() {
        this.isTemplateLocationFunction = ClassUtils.memoize(location -> false, new ConcurrentHashMap());
    }

    public SpringConfigurationComponentLocator(Function<String, Boolean> isTemplateComponentFunction) {
        this.isTemplateLocationFunction = ClassUtils.memoize(isTemplateComponentFunction, new ConcurrentHashMap());
    }

    public void addComponent(Component component) {
        this.componentsMap.put(component.getLocation().getLocation(), component);
    }

    public void addComponentLocation(ComponentLocation location) {
        this.componentLocations.add(location);
    }

    public void removeComponent(Location location) {
        this.componentsMap.remove(location.toString());
    }

    @Override
    public Optional<Component> find(Location location) {
        if (this.isTemplateLocationFunction.apply(location.getGlobalName()).booleanValue()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.componentsMap.get(location.toString()));
    }

    @Override
    public List<Component> find(ComponentIdentifier componentIdentifier) {
        return this.componentsMap.values().stream().filter(component -> component.getLocation().getComponentIdentifier().getIdentifier().equals(componentIdentifier)).collect(Collectors.toList());
    }

    @Override
    public List<ComponentLocation> findAllLocations() {
        return Collections.unmodifiableList(new ArrayList<ComponentLocation>(this.componentLocations));
    }
}

