/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.secutiry.tls;

import java.io.IOException;
import java.util.Properties;
import org.mule.runtime.core.privileged.security.tls.TlsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsPropertiesMapper {
    private static final String TRUST_NAME_SUFFIX = ".ssl.trustStore";
    private static final String TRUST_TYPE_SUFFIX = ".ssl.trustStoreType";
    private static final String TRUST_PASSWORD_SUFFIX = ".ssl.trustStorePassword";
    private static final String TRUST_ALGORITHM_SUFFIX = ".ssl.trustManagerAlgorithm";
    private static final String KEY_NAME_SUFFIX = ".ssl.keyStore";
    private static final String KEY_TYPE_SUFFIX = ".ssl.keyStoreType";
    private static final String KEY_PASSWORD_SUFFIX = ".ssl.keyStorePassword";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String namespace;

    public TlsPropertiesMapper(String namespace) {
        this.namespace = namespace;
    }

    public void readFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        this.readTrustStoreFromProperties(configuration, properties);
        this.readKeyStoreFromProperties(configuration, properties);
    }

    private void readTrustStoreFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        configuration.setTrustStore(this.getProperty(properties, TRUST_NAME_SUFFIX, configuration.getTrustStore()));
        configuration.setTrustStoreType(this.getProperty(properties, TRUST_TYPE_SUFFIX, configuration.getTrustStoreType()));
        configuration.setTrustStorePassword(this.getProperty(properties, TRUST_PASSWORD_SUFFIX, configuration.getTrustStorePassword()));
        configuration.setTrustManagerAlgorithm(this.getProperty(properties, TRUST_ALGORITHM_SUFFIX, configuration.getTrustManagerAlgorithm()));
    }

    private void readKeyStoreFromProperties(TlsConfiguration configuration, Properties properties) throws IOException {
        configuration.setKeyStore(this.getProperty(properties, KEY_NAME_SUFFIX, configuration.getKeyStore()));
        configuration.setKeyStoreType(this.getProperty(properties, KEY_TYPE_SUFFIX, configuration.getKeyStoreType()));
        configuration.setKeyStorePassword(this.getProperty(properties, KEY_PASSWORD_SUFFIX, configuration.getKeyStorePassword()));
    }

    private String getProperty(Properties properties, String suffix, String deflt) {
        String value = properties.getProperty(this.namespace + suffix);
        if (null == value) {
            value = deflt;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.namespace + suffix + " -> " + value);
        }
        return value;
    }
}

