/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.app.declaration.serialization.adapter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterGroupElementDeclarer;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ElementDeclarationSerializationUtils;
import org.mule.runtime.internal.app.declaration.serialization.adapter.ParameterElementDeclarationTypeAdapter;

public class ParameterGroupElementDeclarationTypeAdapter
extends TypeAdapter<ParameterGroupElementDeclaration> {
    private final Gson delegate = new GsonBuilder().registerTypeAdapter(ParameterElementDeclaration.class, (Object)new ParameterElementDeclarationTypeAdapter()).create();

    public void write(JsonWriter out, ParameterGroupElementDeclaration group) throws IOException {
        if (group != null) {
            out.beginObject();
            out.name("name").value(group.getName());
            ElementDeclarationSerializationUtils.populateCustomizableObject(this.delegate, out, group);
            ElementDeclarationSerializationUtils.populateMetadataAwareObject(this.delegate, out, group);
            out.name("parameters").jsonValue(this.delegate.toJson(group.getParameters()));
            out.endObject();
        }
    }

    public ParameterGroupElementDeclaration read(JsonReader in) throws IOException {
        JsonElement parse;
        if (in != null && (parse = new JsonParser().parse(in)).isJsonObject()) {
            JsonObject jsonObject = parse.getAsJsonObject();
            JsonElement elementName = jsonObject.get("name");
            JsonElement elementParameters = jsonObject.get("parameters");
            if (elementName != null && elementParameters != null) {
                ParameterGroupElementDeclarer declarer = (ParameterGroupElementDeclarer)ElementDeclarationSerializationUtils.declareEnrichableElement(this.delegate, jsonObject, ElementDeclarer.newParameterGroup(elementName.getAsString()));
                JsonArray parameters = elementParameters.getAsJsonArray();
                parameters.forEach(p -> {
                    ParameterElementDeclaration param = (ParameterElementDeclaration)this.delegate.fromJson(p, ParameterElementDeclaration.class);
                    declarer.withParameter(param.getName(), param.getValue());
                });
                return (ParameterGroupElementDeclaration)declarer.getDeclaration();
            }
        }
        return null;
    }
}

