/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.service.http.impl.service.server.DefaultRequestHandlerManager;
import org.mule.service.http.impl.service.server.NoListenerRequestHandler;
import org.mule.service.http.impl.service.server.NoMethodRequestHandler;
import org.mule.service.http.impl.service.server.RequestHandlerProvider;
import org.mule.service.http.impl.service.server.ServerAddressMap;
import org.mule.service.http.impl.service.server.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.mule.service.http.impl.service.server.grizzly.AcceptsAllMethodsRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.DefaultMethodRequestMatcher;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListenerRegistry
implements RequestHandlerProvider {
    private static final String WILDCARD_CHARACTER = "*";
    private static final String SLASH = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListenerRegistry.class);
    private final ServerAddressMap<HttpServer> serverAddressToServerMap = new ServerAddressMap();
    private final Map<HttpServer, ServerAddressRequestHandlerRegistry> requestHandlerPerServerAddress = new HashMap<HttpServer, ServerAddressRequestHandlerRegistry>();

    public synchronized RequestHandlerManager addRequestHandler(HttpServer server, RequestHandler requestHandler, PathAndMethodRequestMatcher requestMatcher) {
        ServerAddressRequestHandlerRegistry serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server);
        if (serverAddressRequestHandlerRegistry == null) {
            serverAddressRequestHandlerRegistry = new ServerAddressRequestHandlerRegistry();
            this.requestHandlerPerServerAddress.put(server, serverAddressRequestHandlerRegistry);
            this.serverAddressToServerMap.put(server.getServerAddress(), server);
        }
        return serverAddressRequestHandlerRegistry.addRequestHandler(requestMatcher, requestHandler);
    }

    public synchronized void removeHandlersFor(HttpServer server) {
        this.requestHandlerPerServerAddress.remove(server);
        this.serverAddressToServerMap.remove(server.getServerAddress());
    }

    @Override
    public synchronized boolean hasHandlerFor(ServerAddress serverAddress) {
        return this.serverAddressToServerMap.get(serverAddress) != null;
    }

    @Override
    public RequestHandler getRequestHandler(ServerAddress serverAddress, HttpRequest request) {
        ServerAddressRequestHandlerRegistry serverAddressRequestHandlerRegistry;
        LOGGER.debug("Looking RequestHandler for request: {}", (Object)request.getPath());
        HttpServer server = this.serverAddressToServerMap.get(serverAddress);
        if (server != null && !server.isStopping() && !server.isStopped() && (serverAddressRequestHandlerRegistry = this.requestHandlerPerServerAddress.get(server)) != null) {
            return serverAddressRequestHandlerRegistry.findRequestHandler(request);
        }
        LOGGER.debug("No RequestHandler found for request: {}", (Object)request.getPath());
        return NoListenerRequestHandler.getInstance();
    }

    private boolean isUriParameter(String pathPart) {
        return (pathPart.startsWith("{") || pathPart.startsWith("/{")) && pathPart.endsWith("}");
    }

    private String getLastPathPortion(String possibleCollisionRequestMatcherPath) {
        String[] parts = this.splitPath(possibleCollisionRequestMatcherPath);
        if (parts.length == 0) {
            return "";
        }
        return parts[parts.length - 1];
    }

    private boolean isSameDepth(String possibleCollisionRequestMatcherPath, String newListenerRequestMatcherPath) {
        return this.getPathPartsSize(possibleCollisionRequestMatcherPath) == this.getPathPartsSize(newListenerRequestMatcherPath);
    }

    private int getPathPartsSize(String path) {
        int pathSize = this.splitPath(path).length - 1;
        return pathSize += path.endsWith(SLASH) ? 1 : 0;
    }

    private String[] splitPath(String path) {
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        return path.split(SLASH, -1);
    }

    private boolean isCatchAllPath(String path) {
        return WILDCARD_CHARACTER.equals(path);
    }

    public class RequestHandlerMatcherPair {
        private PathAndMethodRequestMatcher requestMatcher;
        private RequestHandler requestHandler;
        private boolean running = true;

        private RequestHandlerMatcherPair(PathAndMethodRequestMatcher requestMatcher, RequestHandler requestHandler) {
            this.requestMatcher = requestMatcher;
            this.requestHandler = requestHandler;
        }

        public PathAndMethodRequestMatcher getRequestMatcher() {
            return this.requestMatcher;
        }

        public RequestHandler getRequestHandler() {
            return this.requestHandler;
        }

        public boolean isRunning() {
            return this.running;
        }

        public void setIsRunning(Boolean running) {
            this.running = running;
        }
    }

    public class Path {
        List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = new ArrayList<RequestHandlerMatcherPair>();
        private String name;
        private Path parent;
        private Map<String, Path> subPaths = new HashMap<String, Path>();
        private Path catchAll;
        private Path catchAllUriParam;

        public Path(String name, Path parent) {
            this.name = name;
            this.parent = parent;
        }

        public Path getCatchAll() {
            return this.catchAll;
        }

        public Path getCatchAllUriParam() {
            return this.catchAllUriParam;
        }

        public Path getChildPath(String subPath, String nextSubPath) {
            if (HttpListenerRegistry.this.isCatchAllPath(subPath) || HttpListenerRegistry.this.isUriParameter(subPath) || this.isViablePath(nextSubPath) && !this.matchesNextSubPaths(subPath, nextSubPath)) {
                return this.getCatchAllUriParam();
            }
            Path path = this.subPaths.get(subPath);
            return path;
        }

        private boolean isViablePath(String nextSubPath) {
            if (this.getCatchAllUriParam() != null && nextSubPath != null) {
                return this.getCatchAllUriParam().subPaths.containsKey(nextSubPath);
            }
            return false;
        }

        private boolean matchesNextSubPaths(String subPath, String nextSubPath) {
            Path nextPath;
            if (this.subPaths.containsKey(subPath) && (nextPath = this.subPaths.get(subPath)).getSubPaths() != null) {
                return nextPath.getSubPaths().containsKey(nextSubPath);
            }
            return false;
        }

        public Path getLastChildPath(String subPath) {
            if (HttpListenerRegistry.this.isCatchAllPath(subPath) || HttpListenerRegistry.this.isUriParameter(subPath)) {
                return this.getCatchAllUriParam();
            }
            Path path = this.subPaths.get(subPath);
            return path;
        }

        public void addRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (requestHandlerMatcherPair.getRequestMatcher().getMethodRequestMatcher() instanceof AcceptsAllMethodsRequestMatcher) {
                this.requestHandlerMatcherPairs.add(requestHandlerMatcherPair);
            } else {
                this.requestHandlerMatcherPairs.add(0, requestHandlerMatcherPair);
            }
        }

        public void addChildPath(String pathName, Path path) {
            if (pathName.equals(HttpListenerRegistry.WILDCARD_CHARACTER) || pathName.endsWith("}")) {
                this.catchAllUriParam = path;
            } else {
                this.subPaths.put(pathName, path);
            }
        }

        public void removeChildPath(String pathName) {
            this.subPaths.remove(pathName);
            this.removeSelfIfEmpty();
        }

        public boolean isEmpty() {
            return !(!this.requestHandlerMatcherPairs.isEmpty() || !this.subPaths.isEmpty() || this.catchAll != null && !this.catchAll.isEmpty() || this.catchAllUriParam != null && !this.catchAllUriParam.isEmpty());
        }

        public Map<String, Path> getSubPaths() {
            return this.subPaths;
        }

        public List<RequestHandlerMatcherPair> getRequestHandlerMatcherPairs() {
            return this.requestHandlerMatcherPairs;
        }

        public void addWildcardRequestHandler(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.catchAll == null) {
                this.catchAll = new Path(HttpListenerRegistry.WILDCARD_CHARACTER, this);
            }
            this.catchAll.addRequestHandlerMatcherPair(requestHandlerMatcherPair);
        }

        public boolean removeRequestHandlerMatcherPair(RequestHandlerMatcherPair requestHandlerMatcherPair) {
            if (this.requestHandlerMatcherPairs.remove(requestHandlerMatcherPair)) {
                this.removeSelfIfEmpty();
                return true;
            }
            if (this.catchAll != null && this.catchAll.removeRequestHandlerMatcherPair(requestHandlerMatcherPair)) {
                if (this.catchAll.isEmpty()) {
                    this.catchAll = null;
                }
                this.removeSelfIfEmpty();
                return true;
            }
            if (this.catchAllUriParam != null && this.catchAllUriParam.removeRequestHandlerMatcherPair(requestHandlerMatcherPair)) {
                if (this.catchAllUriParam.isEmpty()) {
                    this.catchAllUriParam = null;
                }
                this.removeSelfIfEmpty();
                return true;
            }
            return false;
        }

        private void removeSelfIfEmpty() {
            if (this.isEmpty() && this.parent != null) {
                this.parent.removeChildPath(this.name);
            }
        }
    }

    public class ServerAddressRequestHandlerRegistry {
        private Path serverRequestHandler;
        private Path rootPath;
        private Path catchAllPath;
        private Set<String> paths;

        public ServerAddressRequestHandlerRegistry() {
            this.rootPath = new Path("root", null);
            this.catchAllPath = new Path(HttpListenerRegistry.WILDCARD_CHARACTER, null);
            this.paths = new HashSet<String>();
        }

        public synchronized RequestHandlerManager addRequestHandler(PathAndMethodRequestMatcher requestMatcher, RequestHandler requestHandler) {
            Path requestHandlerOwner;
            RequestHandlerMatcherPair addedRequestHandlerMatcherPair;
            String requestMatcherPath = HttpParser.normalizePathWithSpacesOrEncodedSpaces(requestMatcher.getPath());
            Preconditions.checkArgument(requestMatcherPath.startsWith(HttpListenerRegistry.SLASH) || requestMatcherPath.equals(HttpListenerRegistry.WILDCARD_CHARACTER), "path parameter must start with /");
            this.validateCollision(requestMatcher);
            List<String> matcherMethods = requestMatcher.getMethodRequestMatcher().getMethods();
            this.paths.add(this.getMethodAndPath(DefaultMethodRequestMatcher.getMethodsListRepresentation(matcherMethods), requestMatcherPath));
            Path currentPath = this.rootPath;
            if (requestMatcherPath.equals(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                this.serverRequestHandler = new Path("server", null);
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.serverRequestHandler;
                this.serverRequestHandler.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else if (requestMatcherPath.equals("/*")) {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.catchAllPath;
                this.catchAllPath.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else if (requestMatcherPath.equals(HttpListenerRegistry.SLASH)) {
                addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                requestHandlerOwner = this.rootPath;
                this.rootPath.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
            } else {
                String[] pathParts = HttpListenerRegistry.this.splitPath(requestMatcherPath);
                int insertionLevel = HttpListenerRegistry.this.getPathPartsSize(requestMatcherPath);
                for (int i = 1; i < insertionLevel - 1; ++i) {
                    String currentPathName = pathParts[i];
                    Path path = currentPath.getChildPath(currentPathName, null);
                    if (i != insertionLevel - 1 && path == null) {
                        path = new Path(currentPathName, path);
                        currentPath.addChildPath(currentPathName, path);
                    }
                    currentPath = path;
                }
                String currentPathName = pathParts[insertionLevel - 1];
                Path path = currentPath.getLastChildPath(currentPathName);
                if (path == null) {
                    path = new Path(currentPathName, path);
                    currentPath.addChildPath(currentPathName, path);
                }
                if (requestMatcherPath.endsWith(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                    addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                    path.addWildcardRequestHandler(addedRequestHandlerMatcherPair);
                    requestHandlerOwner = path;
                } else {
                    addedRequestHandlerMatcherPair = new RequestHandlerMatcherPair(requestMatcher, requestHandler);
                    path.addRequestHandlerMatcherPair(addedRequestHandlerMatcherPair);
                    requestHandlerOwner = path;
                }
            }
            return new DefaultRequestHandlerManager(requestHandlerOwner, addedRequestHandlerMatcherPair, this);
        }

        private void validateCollision(PathAndMethodRequestMatcher newListenerRequestMatcher) {
            String newListenerRequestMatcherPath = newListenerRequestMatcher.getPath();
            Stack<Path> possibleRequestHandlers = this.findPossibleRequestHandlers(newListenerRequestMatcherPath);
            for (Path possibleRequestHandler : possibleRequestHandlers) {
                List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = possibleRequestHandler.getRequestHandlerMatcherPairs();
                for (RequestHandlerMatcherPair requestHandlerMatcherPair : requestHandlerMatcherPairs) {
                    String newListenerRequestMatcherLastPathPart;
                    String possibleCollisionLastPathPart;
                    PathAndMethodRequestMatcher requestMatcher = requestHandlerMatcherPair.getRequestMatcher();
                    String possibleCollisionRequestMatcherPath = requestMatcher.getPath();
                    if (!HttpListenerRegistry.this.isSameDepth(possibleCollisionRequestMatcherPath, newListenerRequestMatcherPath) || !newListenerRequestMatcher.getMethodRequestMatcher().intersectsWith(requestMatcher.getMethodRequestMatcher()) || !((possibleCollisionLastPathPart = HttpListenerRegistry.this.getLastPathPortion(possibleCollisionRequestMatcherPath)).equals(newListenerRequestMatcherLastPathPart = HttpListenerRegistry.this.getLastPathPortion(newListenerRequestMatcherPath)) || HttpListenerRegistry.this.isCatchAllPath(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isCatchAllPath(newListenerRequestMatcherLastPathPart) || HttpListenerRegistry.this.isCatchAllPath(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isUriParameter(newListenerRequestMatcherLastPathPart) || HttpListenerRegistry.this.isUriParameter(possibleCollisionLastPathPart) && HttpListenerRegistry.this.isCatchAllPath(newListenerRequestMatcherLastPathPart)) && (!HttpListenerRegistry.this.isUriParameter(possibleCollisionLastPathPart) || !HttpListenerRegistry.this.isUriParameter(newListenerRequestMatcherLastPathPart))) continue;
                    throw new MuleRuntimeException(CoreMessages.createStaticMessage(String.format("Already exists a listener matching that path and methods. Listener matching %s new listener %s", requestMatcher, newListenerRequestMatcher)));
                }
            }
        }

        public RequestHandler findRequestHandler(HttpRequest request) {
            String fullPathName = HttpParser.normalizePathWithSpacesOrEncodedSpaces(request.getPath());
            Preconditions.checkArgument(fullPathName.startsWith(HttpListenerRegistry.SLASH), "path parameter must start with /");
            Stack<Path> foundPaths = this.findPossibleRequestHandlers(fullPathName);
            boolean methodNotAllowed = false;
            RequestHandlerMatcherPair requestHandlerMatcherPair = null;
            while (!foundPaths.empty()) {
                Path path = foundPaths.pop();
                List<RequestHandlerMatcherPair> requestHandlerMatcherPairs = path.getRequestHandlerMatcherPairs();
                if (requestHandlerMatcherPairs == null && path.getCatchAll() != null) {
                    requestHandlerMatcherPairs = path.getCatchAll().requestHandlerMatcherPairs;
                }
                if ((requestHandlerMatcherPair = this.findRequestHandlerMatcherPair(requestHandlerMatcherPairs, request)) != null) break;
                if (requestHandlerMatcherPairs.isEmpty()) continue;
                methodNotAllowed = true;
            }
            if (requestHandlerMatcherPair == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No listener found for request: " + this.getMethodAndPath(request.getMethod(), request.getPath()));
                    LOGGER.info("Available listeners are: [{}]", (Object)Joiner.on((String)", ").join(this.paths));
                }
                if (methodNotAllowed) {
                    return NoMethodRequestHandler.getInstance();
                }
                return NoListenerRequestHandler.getInstance();
            }
            if (!requestHandlerMatcherPair.isRunning()) {
                return ServiceTemporarilyUnavailableListenerRequestHandler.getInstance();
            }
            return requestHandlerMatcherPair.getRequestHandler();
        }

        public void removeRequestHandler(PathAndMethodRequestMatcher requestMatcher) {
            this.paths.remove(this.getMethodAndPath(requestMatcher));
        }

        private String getMethodAndPath(PathAndMethodRequestMatcher matcher) {
            return this.getMethodAndPath(DefaultMethodRequestMatcher.getMethodsListRepresentation(matcher.getMethodRequestMatcher().getMethods()), matcher.getPath());
        }

        private String getMethodAndPath(String method, String path) {
            return "(" + method + ")" + path;
        }

        private Stack<Path> findPossibleRequestHandlers(String fullPathName) {
            Path currentPath = this.rootPath;
            Path auxPath = null;
            String[] pathParts = HttpListenerRegistry.this.splitPath(fullPathName);
            Stack<Path> foundPaths = new Stack<Path>();
            foundPaths.add(this.catchAllPath);
            if (fullPathName.equals(HttpListenerRegistry.WILDCARD_CHARACTER)) {
                foundPaths.push(this.serverRequestHandler);
                return foundPaths;
            }
            if (fullPathName.equals(HttpListenerRegistry.SLASH)) {
                foundPaths.push(this.rootPath);
                return foundPaths;
            }
            for (int i = 1; i < pathParts.length && currentPath != null; ++i) {
                String currentPathName = pathParts[i];
                Path path = currentPath.getChildPath(currentPathName, i < pathParts.length - 1 ? pathParts[i + 1] : null);
                if (path == null) {
                    this.addCatchAllPathIfNotNull(currentPath, foundPaths);
                    path = currentPath.getCatchAllUriParam();
                } else if (path.getCatchAll() != null) {
                    auxPath = path;
                }
                if (i == pathParts.length - 1 || path == null) {
                    if (auxPath != null) {
                        this.addCatchAllPathIfNotNull(auxPath, foundPaths);
                    }
                    if (path != null) {
                        this.addCatchAllPathIfNotNull(path, foundPaths);
                        foundPaths.push(path);
                    } else {
                        this.addCatchAllPathIfNotNull(currentPath, foundPaths);
                    }
                }
                currentPath = path;
            }
            return foundPaths;
        }

        private void addCatchAllPathIfNotNull(Path currentPath, Stack<Path> foundPaths) {
            Path catchAllPath = currentPath.getCatchAll();
            if (catchAllPath != null) {
                foundPaths.push(catchAllPath);
            }
        }

        private RequestHandlerMatcherPair findRequestHandlerMatcherPair(List<RequestHandlerMatcherPair> requestHandlerMatcherPairs, HttpRequest request) {
            for (RequestHandlerMatcherPair requestHandlerMatcherPair : requestHandlerMatcherPairs) {
                if (!requestHandlerMatcherPair.getRequestMatcher().matches(request)) continue;
                return requestHandlerMatcherPair;
            }
            return null;
        }
    }
}

