/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorParameterValue;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterceptorAdapter.class);
    protected static final String INTERCEPTION_COMPONENT = "core:interceptionComponent";
    @Inject
    private MuleContext muleContext;
    @Inject
    protected ExtendedExpressionManager expressionManager;

    AbstractInterceptorAdapter() {
    }

    protected Map<String, ProcessorParameterValue> getResolvedParams(InternalEvent eventWithResolvedParams) {
        return (Map)eventWithResolvedParams.getInternalParameters().get("core:interceptionResolvedParams");
    }

    protected InternalEvent addResolvedParameters(InternalEvent event, Component component, Map<String, String> dslParameters) {
        boolean sameComponent;
        boolean bl = sameComponent = this.internalParametersFrom(event).containsKey(INTERCEPTION_COMPONENT) ? component.equals(this.internalParametersFrom(event).get(INTERCEPTION_COMPONENT)) : false;
        if (!sameComponent || !this.internalParametersFrom(event).containsKey("core:interceptionResolvedParams")) {
            return this.resolveParameters(this.removeResolvedParameters(event), component, dslParameters);
        }
        return event;
    }

    protected InternalEvent removeResolvedParameters(InternalEvent event) {
        return InternalEvent.builder(event).removeInternalParameter("core:interceptionResolvedParams").removeInternalParameter(INTERCEPTION_COMPONENT).removeInternalParameter("core:interceptionResolvedContext").build();
    }

    protected Map<String, ?> internalParametersFrom(CoreEvent event) {
        return ((InternalEvent)event).getInternalParameters();
    }

    protected InternalEvent resolveParameters(InternalEvent event, Component component, Map<String, String> parameters) {
        HashMap<String, ProcessorParameterValue> resolvedParameters = new HashMap<String, ProcessorParameterValue>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String providedValue = entry.getValue();
            resolvedParameters.put(entry.getKey(), new DefaultProcessorParameterValue(entry.getKey(), providedValue, () -> {
                if (this.expressionManager.isExpression(providedValue)) {
                    return this.expressionManager.evaluate(providedValue, (CoreEvent)event, component.getLocation()).getValue();
                }
                return String.valueOf(providedValue);
            }));
        }
        InternalEvent.Builder builder = InternalEvent.builder(event);
        this.setInternalParamsForNotParamResolver(component, resolvedParameters, builder);
        return builder.build();
    }

    protected void setInternalParamsForNotParamResolver(Component component, Map<String, ProcessorParameterValue> resolvedParameters, InternalEvent.Builder builder) {
        HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
        interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
        interceptionEventParams.put(INTERCEPTION_COMPONENT, component);
        builder.internalParameters(interceptionEventParams);
    }

    protected MessagingException createMessagingException(CoreEvent event, Throwable cause, Component processor, Optional<MessagingException> original) {
        MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(processor);
        MessagingException me = new MessagingException(event, cause, processor);
        original.ifPresent(error -> error.getInfo().forEach((name, info) -> me.addInfo((String)name, info)));
        return exceptionResolver.resolve(me, ((PrivilegedMuleContext)this.muleContext).getErrorTypeLocator(), this.muleContext.getExceptionContextProviders());
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }
}

