/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.store.DeserializationPostInitialisable;

public abstract class AbstractSerializationProtocol
implements SerializationProtocol {
    protected MuleContext muleContext;

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    protected abstract <T> T doDeserialize(InputStream var1, ClassLoader var2) throws Exception;

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        try {
            return this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize object", (Throwable)e);
        }
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            byte[] bytes = this.serialize(object);
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not write to output stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) throws SerializationException {
        return this.deserialize(bytes, this.muleContext.getExecutionClassLoader());
    }

    @Override
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        Preconditions.checkArgument(bytes != null, "The byte[] must not be null");
        return this.deserialize(new ByteArrayInputStream(bytes), classLoader);
    }

    @Override
    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, this.muleContext.getExecutionClassLoader());
    }

    @Override
    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        Preconditions.checkArgument(classLoader != null, "Cannot deserialize with a null classloader");
        try {
            T t = this.postInitialize(this.doDeserialize(inputStream, classLoader));
            return t;
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize object", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    protected <T> T postInitialize(T object) throws SerializationException {
        if (object instanceof DeserializationPostInitialisable) {
            try {
                DeserializationPostInitialisable.Implementation.init(object, this.muleContext);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not initialize instance of %s after deserialization", object.getClass().getName()), (Throwable)e);
            }
        }
        return object;
    }

    @Inject
    public final void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

