/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.FineGrainedControlClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.ResourceReleaser;
import org.mule.runtime.module.artifact.api.classloader.ShutdownListener;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleArtifactClassLoader
extends FineGrainedControlClassLoader
implements ArtifactClassLoader {
    private static final Logger LOGGER;
    private static final String DEFAULT_RESOURCE_RELEASER_CLASS_LOCATION = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    static final Pattern DOT_REPLACEMENT_PATTERN;
    static final String PATH_SEPARATOR = "/";
    static final String RESOURCE_PREFIX = "resource::";
    static final String WILDCARD = "*";
    private static final String NO_WILDCARD_NO_SPACES = "([^\\*|\\s]+)";
    private static final String NO_SPACES = "(\\S+)";
    static final Pattern GAV_EXTENDED_PATTERN;
    private static final Pattern MAVEN_ARTIFACT_PATTERN;
    protected List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final String artifactId;
    private final Object localResourceLocatorLock = new Object();
    private volatile LocalResourceLocator localResourceLocator;
    private String resourceReleaserClassLocation = "/org/mule/module/artifact/classloader/DefaultResourceReleaser.class";
    private ResourceReleaser resourceReleaserInstance;
    private ArtifactDescriptor artifactDescriptor;
    private final Object descriptorMappingLock = new Object();
    private Map<BundleDescriptor, URLClassLoader> descriptorMapping = new HashMap<BundleDescriptor, URLClassLoader>();

    public MuleArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(urls, parent, lookupPolicy);
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)artifactId), "artifactId cannot be empty");
        Preconditions.checkArgument(artifactDescriptor != null, "artifactDescriptor cannot be null");
        this.artifactId = artifactId;
        this.artifactDescriptor = artifactDescriptor;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public <T extends ArtifactDescriptor> T getArtifactDescriptor() {
        return (T)this.artifactDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL findResource(String name) {
        Matcher matcher;
        if (name.startsWith(RESOURCE_PREFIX) && (matcher = GAV_EXTENDED_PATTERN.matcher(name)).matches()) {
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            String version = matcher.group(3);
            String classifier = matcher.group(4);
            String type = matcher.group(5);
            String resource = matcher.group(6);
            LOGGER.debug("Artifact request for '{}' in group '{}', artifact '{}' and version '{}', with classifier '{}' and type '{}'.", new Object[]{resource, groupId, artifactId, version, classifier, type});
            String normalizedResource = FilenameUtils.normalize((String)resource, (boolean)true);
            BundleDescriptor requestDescriptor = new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setClassifier(classifier).setType(type).build();
            URLClassLoader classLoader = WILDCARD.equals(version) ? (URLClassLoader)this.descriptorMapping.entrySet().stream().filter(entry -> this.isRequestedArtifact((BundleDescriptor)entry.getKey(), requestDescriptor, () -> false)).map(Map.Entry::getValue).findAny().orElse(null) : this.descriptorMapping.get(requestDescriptor);
            if (classLoader != null) {
                return classLoader.findResource(normalizedResource);
            }
            Optional<URL> match = Arrays.stream(this.getURLs()).filter(url -> {
                String urlPath = url.getPath();
                return urlPath.contains(this.asPath(requestDescriptor)) && urlPath.endsWith(this.asExtension(requestDescriptor));
            }).findFirst();
            if (match.isPresent()) {
                URL url2 = match.get();
                BundleDescriptor matchDescriptor = this.toBundleDescriptor(url2, groupId);
                Object object = this.descriptorMappingLock;
                synchronized (object) {
                    if (this.descriptorMapping.get(matchDescriptor) == null) {
                        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{url2});
                        this.descriptorMapping.put(matchDescriptor, urlClassLoader);
                    }
                }
                return this.descriptorMapping.get(matchDescriptor).findResource(normalizedResource);
            }
        }
        return super.findResource(name);
    }

    private String asPath(BundleDescriptor descriptor) {
        String groupIdPath = this.getGroupIdPath(descriptor.getGroupId());
        String versionPath = WILDCARD.equals(descriptor.getVersion()) ? "" : descriptor.getVersion();
        return groupIdPath + PATH_SEPARATOR + descriptor.getArtifactId() + PATH_SEPARATOR + versionPath;
    }

    private String asExtension(BundleDescriptor descriptor) {
        return descriptor.getClassifier().orElse("") + "." + descriptor.getType();
    }

    private BundleDescriptor toBundleDescriptor(URL artifactUrl, String groupId) {
        String artifactPath = artifactUrl.getPath();
        String groupIdPath = this.getGroupIdPath(groupId);
        int artifactIdIndex = artifactPath.indexOf(groupIdPath) + groupIdPath.length();
        Matcher urlMatcher = MAVEN_ARTIFACT_PATTERN.matcher(artifactPath.substring(artifactIdIndex));
        urlMatcher.find();
        return new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(urlMatcher.group(1)).setVersion(urlMatcher.group(2)).setClassifier(urlMatcher.group(3)).setType(urlMatcher.group(4)).build();
    }

    private String getGroupIdPath(String groupId) {
        return DOT_REPLACEMENT_PATTERN.matcher(groupId).replaceAll(PATH_SEPARATOR);
    }

    boolean isRequestedArtifact(BundleDescriptor descriptor, BundleDescriptor artifact, Supplier<Boolean> onVersionMismatch) {
        return this.isRequestedArtifact(descriptor, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType(), onVersionMismatch);
    }

    boolean isRequestedArtifact(BundleDescriptor descriptor, String groupId, String artifactId, String version, Optional<String> classifier, String type, Supplier<Boolean> onVersionMismatch) {
        boolean versionResult = true;
        if (!descriptor.getVersion().equals(version) && !WILDCARD.equals(version)) {
            versionResult = onVersionMismatch.get();
        }
        return descriptor.getGroupId().equals(groupId) && descriptor.getArtifactId().equals(artifactId) && versionResult && descriptor.getClassifier().equals(classifier) && descriptor.getType().equals(type);
    }

    protected String[] getLocalResourceLocations() {
        return new String[0];
    }

    @Override
    public ClassLoader getClassLoader() {
        return this;
    }

    @Override
    public void addShutdownListener(ShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void dispose() {
        this.descriptorMapping.forEach((descriptor, classloader) -> {
            try {
                classloader.close();
            }
            catch (IOException e) {
                this.reportPossibleLeak(e, descriptor.getArtifactId());
            }
        });
        this.descriptorMapping.clear();
        try {
            this.createResourceReleaserInstance().release();
        }
        catch (Exception e) {
            LOGGER.error("Cannot create resource releaser instance", (Throwable)e);
        }
        super.dispose();
        this.shutdownListeners();
    }

    void reportPossibleLeak(Exception e, String artifactId) {
        String message = "Error disposing classloader for '{}'. This can cause a memory leak";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Error disposing classloader for '{}'. This can cause a memory leak", (Object)artifactId, (Object)e);
        } else {
            LOGGER.error("Error disposing classloader for '{}'. This can cause a memory leak", (Object)artifactId);
        }
    }

    private void shutdownListeners() {
        for (ShutdownListener listener : this.shutdownListeners) {
            try {
                listener.execute();
            }
            catch (Exception e) {
                LOGGER.error("Error executing shutdown listener", (Throwable)e);
            }
        }
        this.shutdownListeners.clear();
    }

    private <T> T createCustomInstance(String classLocation) {
        Object obj;
        InputStream classStream = null;
        try {
            classStream = this.getClass().getResourceAsStream(classLocation);
            byte[] classBytes = IOUtils.toByteArray(classStream);
            classStream.close();
            Class<?> clazz = this.defineClass(null, classBytes, 0, classBytes.length);
            obj = clazz.newInstance();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Can not create instance from resource: " + classLocation, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(classStream);
        return (T)obj;
    }

    protected ResourceReleaser createResourceReleaserInstance() {
        if (this.resourceReleaserInstance == null) {
            this.resourceReleaserInstance = (ResourceReleaser)this.createCustomInstance(this.resourceReleaserClassLocation);
        }
        return this.resourceReleaserInstance;
    }

    public void setResourceReleaserClassLocation(String resourceReleaserClassLocation) {
        this.resourceReleaserClassLocation = resourceReleaserClassLocation;
    }

    @Override
    public URL findLocalResource(String resourceName) {
        return this.getLocalResourceLocator().findLocalResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalResourceLocator getLocalResourceLocator() {
        if (this.localResourceLocator == null) {
            Object object = this.localResourceLocatorLock;
            synchronized (object) {
                if (this.localResourceLocator == null) {
                    this.localResourceLocator = new DirectoryResourceLocator(this.getLocalResourceLocations());
                }
            }
        }
        return this.localResourceLocator;
    }

    public String toString() {
        return String.format("%s[%s]@%s", this.getClass().getName(), this.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    static {
        MuleArtifactClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(MuleArtifactClassLoader.class);
        DOT_REPLACEMENT_PATTERN = Pattern.compile("\\.");
        GAV_EXTENDED_PATTERN = Pattern.compile("resource::([^\\*|\\s]+):([^\\*|\\s]+):(\\S+):([^\\*|\\s]+)?:([^\\*|\\s]+):([^\\*|\\s]+)");
        MAVEN_ARTIFACT_PATTERN = Pattern.compile("/(\\S+)/(\\S+)/\\1-\\2-?(\\S+)?\\.(\\S+)");
    }
}

