/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.java.property.DefaultEncodingModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.reflections.ReflectionUtils;

public final class DefaultEncodingDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                DefaultEncodingDeclarationEnricher.this.doEnrich(declaration);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
                DefaultEncodingDeclarationEnricher.this.doEnrich(declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                DefaultEncodingDeclarationEnricher.this.doEnrich(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void doEnrich(BaseDeclaration declaration) {
        declaration.getModelProperty(ImplementingTypeModelProperty.class).ifPresent(p -> {
            ImplementingTypeModelProperty typeProperty = (ImplementingTypeModelProperty)p;
            Set fields = ReflectionUtils.getAllFields(typeProperty.getType(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(DefaultEncoding.class)});
            if (CollectionUtils.isEmpty((Collection)fields)) {
                return;
            }
            if (fields.size() > 1) {
                throw new IllegalConfigurationModelDefinitionException(String.format("Only one field is allowed to be annotated with @%s, but class '%s' has %d fields with such annotation. Offending fields are: [%s]", DefaultEncoding.class.getSimpleName(), typeProperty.getType().getName(), fields.size(), Joiner.on((String)", ").join((Iterable)fields.stream().map(Field::getName).collect(Collectors.toList()))));
            }
            Field defaultEncodingField = (Field)fields.iterator().next();
            if (!String.class.equals(defaultEncodingField.getType())) {
                throw new IllegalConfigurationModelDefinitionException(String.format("Class '%s' declares the field '%s' which is annotated with @%s and is of type '%s'. Only fields of type String are allowed to carry such annotation", typeProperty.getType().getName(), defaultEncodingField.getName(), DefaultEncoding.class.getSimpleName(), defaultEncodingField.getType().getName()));
            }
            declaration.addModelProperty(new DefaultEncodingModelProperty(defaultEncodingField));
        });
    }
}

