/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.ImportedTypes;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class ImportedTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.INITIALIZE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer descriptor = extensionLoadingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)descriptor.getDeclaration();
        Optional<ExtensionTypeDescriptorModelProperty> extensionType = extensionDeclaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        if (!extensionType.isPresent()) {
            return;
        }
        Type type = extensionType.get().getType();
        List<AnnotationValueFetcher<Import>> importTypes = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, Import.class, c -> ((ImportedTypes)c).value());
        if (!importTypes.isEmpty()) {
            if (importTypes.stream().map(annotation -> annotation.getClassValue(Import::type)).distinct().collect(Collectors.toList()).size() != importTypes.size()) {
                throw new IllegalModelDefinitionException(String.format("There should be only one Import declaration for any given type in extension [%s]. Multiple imports of the same type are not allowed", extensionDeclaration.getName()));
            }
            importTypes.forEach(imported -> {
                MetadataType importedType = imported.getClassValue(Import::type).asMetadataType();
                if (!(importedType instanceof ObjectType)) {
                    throw new IllegalArgumentException(String.format("Type '%s' is not complex. Only complex types can be imported from other extensions.", type.getTypeName()));
                }
                extensionDeclaration.addImportedType(new ImportedTypeModel((ObjectType)importedType));
            });
        }
    }
}

