/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.exception.ClassNotFoundInRegionException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.CompoundEnumeration;

public class RegionClassLoader
extends MuleDeployableArtifactClassLoader {
    protected static final String REGION_OWNER_CANNOT_BE_REMOVED_ERROR = "Region owner cannot be removed";
    private static final String CLASS_EXTENSION = ".class";
    private static final Logger LOGGER;
    private final ReadWriteLock innerStateRWLock = new ReentrantReadWriteLock();
    private final Lock innerStateReadLock = this.innerStateRWLock.readLock();
    private final Lock innerStateWriteLock = this.innerStateRWLock.writeLock();
    private final List<RegionMemberClassLoader> registeredClassLoaders = new ArrayList<RegionMemberClassLoader>();
    private final Map<String, ArtifactClassLoader> packageMapping = new HashMap<String, ArtifactClassLoader>();
    private final Map<String, List<ArtifactClassLoader>> resourceMapping = new HashMap<String, List<ArtifactClassLoader>>();
    private final Object descriptorMappingLock = new Object();
    private final Map<BundleDescriptor, URLClassLoader> descriptorMapping = new HashMap<BundleDescriptor, URLClassLoader>();
    private ArtifactClassLoader ownerClassLoader;

    public RegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, new URL[0], parent, lookupPolicy, Collections.emptyList());
    }

    @Override
    public List<ArtifactClassLoader> getArtifactPluginClassLoaders() {
        return this.registeredClassLoaders.stream().map(r -> r.unfilteredClassLoader).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassLoader(ArtifactClassLoader artifactClassLoader, ArtifactClassLoaderFilter filter) {
        Preconditions.checkArgument(artifactClassLoader != null, "artifactClassLoader cannot be null");
        Preconditions.checkArgument(filter != null, "filter cannot be null");
        this.innerStateWriteLock.lock();
        try {
            RegionMemberClassLoader registeredClassLoader = this.findRegisteredClassLoader(artifactClassLoader);
            if (artifactClassLoader == this.ownerClassLoader || registeredClassLoader != null) {
                throw new IllegalArgumentException(RegionClassLoader.createClassLoaderAlreadyInRegionError(artifactClassLoader.getArtifactId()));
            }
            if (this.ownerClassLoader == null) {
                this.ownerClassLoader = artifactClassLoader;
            } else {
                this.registeredClassLoaders.add(new RegionMemberClassLoader(artifactClassLoader, filter));
            }
            filter.getExportedClassPackages().forEach(p -> {
                LookupStrategy packageLookupStrategy = this.getClassLoaderLookupPolicy().getPackageLookupStrategy((String)p);
                if (!(packageLookupStrategy instanceof ChildFirstLookupStrategy)) {
                    throw new IllegalStateException(RegionClassLoader.illegalPackageMappingError(p, packageLookupStrategy));
                }
                if (this.packageMapping.containsKey(p)) {
                    throw new IllegalStateException(RegionClassLoader.duplicatePackageMappingError(p, this.packageMapping.get(p), artifactClassLoader));
                }
                this.packageMapping.put((String)p, artifactClassLoader);
            });
            for (String exportedResource : filter.getExportedResources()) {
                List classLoaders = this.resourceMapping.computeIfAbsent(FilenameUtils.normalize((String)exportedResource, (boolean)true), k -> new ArrayList());
                classLoaders.add(artifactClassLoader);
            }
            for (String exportedClassPackage : filter.getExportedClassPackages()) {
                String packageAsDirectory = FilenameUtils.normalize((String)DOT_REPLACEMENT_PATTERN.matcher(exportedClassPackage).replaceAll("/"), (boolean)true);
                List classLoaders = this.resourceMapping.computeIfAbsent(packageAsDirectory, k -> new ArrayList());
                classLoaders.add(artifactClassLoader);
                classLoaders = this.resourceMapping.computeIfAbsent(FilenameUtils.normalize((String)(packageAsDirectory + "/")), k -> new ArrayList());
                classLoaders.add(artifactClassLoader);
            }
        }
        finally {
            this.innerStateWriteLock.unlock();
        }
    }

    static String illegalPackageMappingError(String p, LookupStrategy packageLookupStrategy) {
        return String.format("Attempt to map package '%s' which was already defined on the region lookup policy with '%s'", p, packageLookupStrategy.getClass().getName());
    }

    static String duplicatePackageMappingError(String packageName, ArtifactClassLoader originalDefinitionClassLoader, ArtifactClassLoader overridingDefinitionClassLoader) {
        return String.format("Attempt to redefine mapping for package: '%s'. Original definition classloader is %s, Overriding definition classloader is %s", packageName, originalDefinitionClassLoader.toString(), overridingDefinitionClassLoader.toString());
    }

    private RegionMemberClassLoader findRegisteredClassLoader(ArtifactClassLoader artifactClassLoader) {
        for (RegionMemberClassLoader registeredClassLoader : this.registeredClassLoaders) {
            if (registeredClassLoader.unfilteredClassLoader != artifactClassLoader) continue;
            return registeredClassLoader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeClassLoader(ArtifactClassLoader artifactClassLoader) {
        Preconditions.checkArgument(artifactClassLoader != null, "artifactClassLoader cannot be null");
        if (this.ownerClassLoader == artifactClassLoader) {
            throw new IllegalArgumentException(REGION_OWNER_CANNOT_BE_REMOVED_ERROR);
        }
        this.innerStateWriteLock.lock();
        try {
            RegionMemberClassLoader registeredClassLoader = this.findRegisteredClassLoader(artifactClassLoader);
            int index = this.registeredClassLoaders.indexOf(registeredClassLoader);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            if (!registeredClassLoader.filter.getExportedClassPackages().isEmpty() || !registeredClassLoader.filter.getExportedResources().isEmpty()) {
                throw new IllegalArgumentException(RegionClassLoader.createCannotRemoveClassLoaderError(artifactClassLoader.getArtifactId()));
            }
            this.registeredClassLoaders.remove(index);
            boolean bl = true;
            return bl;
        }
        finally {
            this.innerStateWriteLock.unlock();
        }
    }

    @Override
    public Class<?> findLocalClass(String name) throws ClassNotFoundException {
        this.innerStateReadLock.lock();
        try {
            String packageName = ClassUtils.getPackageName((String)name);
            ArtifactClassLoader artifactClassLoader = this.packageMapping.get(packageName);
            if (artifactClassLoader != null) {
                try {
                    Class<?> clazz = artifactClassLoader.findLocalClass(name);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundInRegionException(name, this.getArtifactId(), artifactClassLoader.getArtifactId(), e);
                }
            }
            throw new ClassNotFoundInRegionException(name, this.getArtifactId());
        }
        finally {
            this.innerStateReadLock.unlock();
        }
    }

    @Override
    public final URL findResource(String name) {
        block8: {
            String normalizedName;
            block9: {
                String normalizedResource;
                String type;
                String classifier;
                String version;
                String artifactId;
                String groupId;
                block10: {
                    block7: {
                        normalizedName = FilenameUtils.normalize((String)name, (boolean)true);
                        List<ArtifactClassLoader> artifactClassLoaders = this.resourceMapping.get(normalizedName);
                        if (artifactClassLoaders == null) break block7;
                        for (ArtifactClassLoader artifactClassLoader : artifactClassLoaders) {
                            URL url = artifactClassLoader.findResource(normalizedName);
                            if (url == null) continue;
                            return url;
                        }
                        break block8;
                    }
                    if (!name.startsWith("resource::")) break block9;
                    Matcher matcher = GAV_EXTENDED_PATTERN.matcher(name);
                    if (!matcher.matches()) break block8;
                    groupId = matcher.group(1);
                    artifactId = matcher.group(2);
                    version = matcher.group(3);
                    classifier = matcher.group(4);
                    type = matcher.group(5);
                    String resource = matcher.group(6);
                    LOGGER.debug("Region request for '{}' in group '{}', artifact '{}' and version '{}', with classifier '{}' and type '{}'.", new Object[]{resource, groupId, artifactId, version, classifier, type});
                    normalizedResource = FilenameUtils.normalize((String)resource, (boolean)true);
                    if (!ArtifactConstants.API_CLASSIFIERS.contains(classifier) || !"zip".equals(type) || "*".equals(version)) break block10;
                    BundleDescriptor requiredDescriptor = new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setClassifier(classifier).setType(type).build();
                    URLClassLoader classLoader = this.descriptorMapping.get(requiredDescriptor);
                    if (classLoader != null) {
                        return classLoader.findResource(normalizedResource);
                    }
                    ClassLoaderModel classLoaderModel = ((ArtifactDescriptor)this.getArtifactDescriptor()).getClassLoaderModel();
                    for (BundleDependency dependency : classLoaderModel.getDependencies()) {
                        BundleDescriptor descriptor = dependency.getDescriptor();
                        if (!this.isRequestedArtifact(descriptor, requiredDescriptor, () -> false)) continue;
                        return this.descriptorMapping.computeIfAbsent(descriptor, d -> {
                            Object object = this.descriptorMappingLock;
                            synchronized (object) {
                                if (this.descriptorMapping.containsKey(descriptor)) {
                                    return this.descriptorMapping.get(descriptor);
                                }
                                try {
                                    return new URLClassLoader(new URL[]{dependency.getBundleUri().toURL()});
                                }
                                catch (MalformedURLException e) {
                                    throw new MuleRuntimeException(e);
                                }
                            }
                        }).findResource(normalizedResource);
                    }
                    break block8;
                }
                List<ArtifactClassLoader> exportingArtifactClassLoaders = this.resourceMapping.get(normalizedResource);
                if (exportingArtifactClassLoaders == null) break block8;
                for (ArtifactClassLoader artifactClassLoader : exportingArtifactClassLoaders) {
                    BundleDescriptor descriptor = ((ArtifactDescriptor)artifactClassLoader.getArtifactDescriptor()).getBundleDescriptor();
                    if (descriptor == null || !this.isRequestedArtifact(descriptor, groupId, artifactId, version, Optional.ofNullable(classifier), type, () -> {
                        LOGGER.warn("Required version '{}' for artifact '{}:{}' not found. Searching in available version '{}'...", new Object[]{version, descriptor.getGroupId(), descriptor.getArtifactId(), descriptor.getVersion()});
                        return true;
                    })) continue;
                    return artifactClassLoader.findResource(normalizedResource);
                }
                break block8;
            }
            if (name.endsWith(CLASS_EXTENSION)) {
                int lastIndexOfPackageSeparator = name.lastIndexOf("/");
                String resourceFolder = name.substring(0, lastIndexOfPackageSeparator != -1 ? lastIndexOfPackageSeparator : 0);
                List<ArtifactClassLoader> resourceFolderArtifactClassLoaders = this.resourceMapping.get(resourceFolder);
                if (resourceFolderArtifactClassLoaders == null) {
                    return null;
                }
                for (ArtifactClassLoader resourceFolderArtifactClassLoader : resourceFolderArtifactClassLoaders) {
                    URL url = resourceFolderArtifactClassLoader.findResource(normalizedName);
                    if (url == null) continue;
                    return url;
                }
            }
        }
        return null;
    }

    @Override
    public final Enumeration<URL> findResources(String name) throws IOException {
        String normalizedName = FilenameUtils.normalize((String)name, (boolean)true);
        List<ArtifactClassLoader> artifactClassLoaders = this.resourceMapping.get(normalizedName);
        ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>(this.registeredClassLoaders.size());
        if (artifactClassLoaders != null) {
            for (ArtifactClassLoader artifactClassLoader : artifactClassLoaders) {
                Enumeration<URL> partialResources = artifactClassLoader.findResources(normalizedName);
                if (!partialResources.hasMoreElements()) continue;
                enumerations.add(partialResources);
            }
        }
        return new CompoundEnumeration(enumerations.toArray(new Enumeration[0]));
    }

    @Override
    public void dispose() {
        this.registeredClassLoaders.stream().map(c -> c.unfilteredClassLoader).forEach(this::disposeClassLoader);
        this.registeredClassLoaders.clear();
        this.descriptorMapping.forEach((descriptor, classloader) -> {
            try {
                classloader.close();
            }
            catch (IOException e) {
                this.reportPossibleLeak(e, descriptor.getArtifactId());
            }
        });
        this.descriptorMapping.clear();
        this.disposeClassLoader(this.ownerClassLoader);
        super.dispose();
    }

    private void disposeClassLoader(ArtifactClassLoader classLoader) {
        try {
            classLoader.dispose();
        }
        catch (Exception e) {
            this.reportPossibleLeak(e, classLoader.getArtifactId());
        }
    }

    @Override
    public URL findLocalResource(String resourceName) {
        URL resource = this.getOwnerClassLoader().findLocalResource(resourceName);
        if (resource == null && this.getParent() instanceof LocalResourceLocator) {
            resource = ((LocalResourceLocator)((Object)this.getParent())).findLocalResource(resourceName);
        }
        return resource;
    }

    private ArtifactClassLoader getOwnerClassLoader() {
        return this.ownerClassLoader;
    }

    @Override
    public String toString() {
        return String.format("%s[%s] @%s", this.getClass().getName(), this.getArtifactId(), Integer.toHexString(System.identityHashCode(this)));
    }

    static String createCannotRemoveClassLoaderError(String artifactId) {
        return String.format("Cannot remove classloader '%s' as it exports at least a package or resource", artifactId);
    }

    static String createClassLoaderAlreadyInRegionError(String artifactId) {
        return "Region already contains classloader for artifact:" + artifactId;
    }

    static {
        RegionClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(RegionClassLoader.class);
    }

    private static class RegionMemberClassLoader {
        final ArtifactClassLoader unfilteredClassLoader;
        final ArtifactClassLoaderFilter filter;

        private RegionMemberClassLoader(ArtifactClassLoader unfilteredClassLoader, ArtifactClassLoaderFilter filter) {
            this.unfilteredClassLoader = unfilteredClassLoader;
            this.filter = filter;
        }
    }
}

